//
//  TNKWalkNavManager.h
//  TencentNavKit
//
//  Created by mol on 2022/10/26.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <TencentNavKit/TNKBaseNavManager.h>
#import <TencentNavKit/TNKWalkCommonObj.h>
#import <TencentNavKit/TNKWalkNavDelegate.h>
#import <TencentNavKit/TNKSearchTask.h>
#import <TencentNavKit/TNKWalkNavDataSource.h>
NS_ASSUME_NONNULL_BEGIN


/// 步行导航管理类
@interface TNKWalkNavManager : TNKBaseNavManager

/// 单例模式，获取导航管理对象
+ (instancetype)sharedInstance;

/**
 *  @brief 当前正在导航时的主路线数据。非导航时为nil
 */
@property (nonatomic, readonly, nullable) TNKWalkNavRoute *curNavRoute;

/**
 * @brief 导航事件DataSource. since 5.2.6
 */
@property (nonatomic, weak, nullable) id<TNKWalkNavDataSource> navDataSource;

/**
 * @brief 导航播报模式，默认为标准模式.
 * @since 5.3.9
 */
@property (nonatomic, assign) TNKNavTTSMode ttsMode;

/**
 * @brief 注册对象接收导航事件变化.
 *  注册后可通过该协议获取导航过程中出现的状态或信息改变(如已偏航、经过途经点、到达终点等).
 *  导航事件变化采用广播形式,可同时注册多个对象接收事件变化.
 * @warning 内部对navDelegate弱持有
 * @param navDelegate 接收导航事件变化的对象
 */
- (void)registerNavDelegate:(id<TNKWalkNavDelegate>)navDelegate;

/**
 * @brief 注销对象接收导航事件变化.
 * @param navDelegate 接收导航事件变化的对象
 */
- (void)unregisterNavDelegate:(id<TNKWalkNavDelegate>)navDelegate;

/**
 * @brief 注销所有对象接收导航事件变化.
 */
- (void)unregisterAllNavDelegates;


- (TNKSearchTask * _Nullable)searchRoutesWithRequest:(TNKRouteRequest *)request
                                          completion:(void (^)(TNKWalkRouteSearchResult * _Nullable searchResult,
                                                               NSError * _Nullable error))completion;

@end

NS_ASSUME_NONNULL_END
