//
//  TNKSnapShotResult.h
//  TencentNavKit
//
//  Created on 2025/9/22.
//  Copyright © 2025 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 截图结果类
 */
@interface TNKSnapShotResult : NSObject

/**
 * @brief 截图图像
 */
@property (nonatomic, strong, readonly) UIImage *image;

/**
 * @brief 版本信息
 */
@property (nonatomic, assign, readonly) int version;

/**
 * @brief 截图时间戳
 */
@property (nonatomic, assign, readonly) NSTimeInterval timestamp;

/**
 * @brief 数据是否变更
 */
@property (nonatomic, assign, readonly) BOOL changed;

@end

NS_ASSUME_NONNULL_END
