//
//  TNKSnapShotConfig.h
//  TencentNavKit
//
//  Created on 2025/9/22.
//  Copyright © 2025 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 截图配置类
 */
@interface TNKSnapShotConfig : NSObject

/**
 * @brief 截图区域宽，默认 256
 */
@property (nonatomic, assign) CGFloat width;

/**
 * @brief 截图区域宽，默认 256
 */
@property (nonatomic, assign) CGFloat height;

/**
 * @brief 截图的间隔（秒）。最小1秒，最大10秒。
 */
@property (nonatomic, assign) NSTimeInterval interval;

/**
 * @brief 前台截图时使用静态图（默认开启）
 */
@property (nonatomic, assign) BOOL usesStaticMapWhenAppActive;

@end

NS_ASSUME_NONNULL_END
