//
//  TNKSegmentItem.h
//  TencentNavKit
//
//  Created by mol on 2022/10/10.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 道路等级
typedef enum _TNKRoadGrade
{
    TNKRoadGradeNull        = -1,    /**< 无效值 */
    TNKRoadGradeHighWay     = 0,     /**< 高速 */
    TNKRoadGradeFastWay     = 1,     /**< 城市快速路 */
    TNKRoadGradeNationWay   = 2,     /**< 国道 */
    TNKRoadGradeProvinceWay = 3,     /**< 省道 */
    TNKRoadGradeCountryWay  = 4,     /**< 县道 */
    TNKRoadGradeTownWay     = 6,     /**< 乡村公路 */
    TNKRoadGradeOtherWay    = 8,     /**< 其它道路 */
    TNKRoadGradeNineWay     = 9,     /**< 九级道路 */
    TNKRoadGradeFerryWay    = 10,    /**< 轮渡 */
    TNKRoadGradeFootWay     = 11,    /**< 行人道路 */
    TNKRoadGradeBicycle     = 13,    /**< 自行车专用路 */
} TNKRoadGrade;

/// 道路属性
typedef enum _TNKRoadKind
{
    TNKRoadKindNull       = -1,  /**< 无效值 */
    TNKRoadKindRoundabout = 0,   /**< 环岛 */
    TNKRoadKindNormal     = 1,   /**< 普通道路 */
    TNKRoadKindSeparate   = 2,   /**< 上下线分离道路 */
    TNKRoadKindJCT        = 3,   /**< 高速之间的连接道路 */
    TNKRoadKindInner      = 4,   /**< 内部路 */
    TNKRoadKindRamp       = 5,   /**< 匝道 */
    TNKRoadKindPA         = 6,   /**< 停车区 */
    TNKRoadKindSA         = 7,   /**< 服务区 */
    TNKRoadKindRightTurn  = 8,   /**< 起提前右转弯作用的道路 */
    TNKRoadKindLeftTurn   = 9,   /**< 起提前左转弯作用的道路 */
    TNKRoadKindUturn      = 10,  /**< 调头路 */
    TNKRoadKindIC         = 11,  /**< 连接高速和其它不同等级道路之间的道路 */
    TNKRoadKindMainSideIC = 12,  /**< 辅主辅路出入口 */
    TNKRoadKindTunnel     = 13,  /**< 隧道 */
    TNKRoadKindMainRoad   = 14,  /**< 主路 */
    TNKRoadKindSideRoad   = 15,  /**< 辅路 */
    TNKRoadKindBridge     = 16   /**< 桥梁 */
} TNKRoadKind;



/**
 * @brief 路名信息
 */
@interface TNKSegmentRoadName : NSObject

/**
 * @brief segment中点串序列起始index.
 */
@property (nonatomic, readonly) int from;

/**
 * @brief segment中点串序列终止index.
 */
@property (nonatomic, readonly) int to;

/**
 * @brief segment路名
 */
@property (nonatomic, readonly) NSString *roadName;

/**
 * @brief 道路行政等级
 */
@property (nonatomic, readonly) TNKRoadGrade grade;

/**
 * @brief 道路属性
 */
@property (nonatomic, readonly) TNKRoadKind roadKind;

/**
 * @brief 长度.单位，米
 */
@property (nonatomic, readonly) int length;

@end

/**
 * @brief 线段管理类
 */
@interface TNKSegmentItem : NSObject

/**
 * @brief segment中点串序列起始index.
 */
@property (nonatomic, readonly) int from;

/**
 * @brief 下一个segment点串序列起始index.
 */
@property (nonatomic, readonly) int to;

/**
 * @brief segment长度.
 */
@property (nonatomic, readonly) int roadLength;

/**
 * @brief segment路名 需要和segRoadNames一起连用
 */
@property (nonatomic, readonly) NSString *roadName;

/**
 * @brief 补充不完整的segment路名. since 5.2.3
 */
@property (nonatomic, readonly) NSArray<TNKSegmentRoadName *> *segRoadNames;

/**
 * @brief 进入segment action
 */
@property (nonatomic, readonly) NSString *action;

/**
 * @brief 进入segment 方向
 */
@property (nonatomic, readonly) NSString *direction;

/**
 * @brief 经过红绿灯个数
 */
@property (nonatomic, readonly) int trafficLightCount;

/**
 * @brief 所在城市的adcode
 */
@property (nonatomic, readonly) int adcode;

@end

NS_ASSUME_NONNULL_END
