//
//  TNKRouteTrafficItem.h
//  TencentNavKit
//
//  Created by mol on 2022/10/10.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

/**
 * @brief 交通状态
 */
typedef enum _TNKRouteTrafficDataStatus
{
    TNKRouteTrafficDataStatusPassed = -1,     ///< 已走过的路
    TNKRouteTrafficDataStatusSmooth = 0,      ///< 通畅
    TNKRouteTrafficDataStatusSlow = 1,        ///< 缓行
    TNKRouteTrafficDataStatusVerySlow = 2,    ///< 堵塞
    TNKRouteTrafficDataStatusUnkown = 3,      ///< 未知路况
    TNKRouteTrafficDataStatusJam = 4,         ///< 严重堵塞
    TNKWalkRouteTrafficDataStatus = 5,        ///< 步骑行导航路线颜色
} TNKRouteTrafficDataStatus;


NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 路线路况分段数据类
 */
@interface TNKRouteTrafficItem : NSObject

/**
 * @brief 该段路线距离。单位：米
 */
@property (nonatomic, readonly) int distance;

/**
 * @brief 该段路线起点在路线点串中的索引. 索引值从0开始, 若该段为偏航前行驶部分, 则索引值为-1. 绘制导航路况线时请将第一段剔除.
 */
@property (nonatomic, readonly) int from;

/**
 * @brief 该段路线终点在路线点串中的索引. 若该段为偏航前行驶部分, 则索引值为0.
 */
@property (nonatomic, readonly) int to;

/**
 * @brief 该段路况状态 0:通畅 1:缓行 2:堵塞 3:未知路况 4:严重堵塞.
 */
@property (nonatomic, readonly) TNKRouteTrafficDataStatus trafficStatus;


/// 获取导航SDK默认路况颜色
UIColor *TNKRouteTrafficStatusColor(TNKRouteTrafficDataStatus trafficDataStatus);

/// 获取导航SDK默认路况描边颜色
UIColor *TNKRouteTrafficStatusBorderColor(TNKRouteTrafficDataStatus trafficDataStatus);

/// 获取导航SDK伴随路线默认路况颜色
UIColor *TNKAccompanyRouteTrafficStatusColor(TNKRouteTrafficDataStatus trafficDataStatus);

/// 获取导航SDK伴随路线默认路况描边颜色
UIColor *TNKAccompanyRouteTrafficStatusBorderColor(TNKRouteTrafficDataStatus trafficDataStatus);

@end

NS_ASSUME_NONNULL_END
