//
//  TNKRideNavigationData.h
//  TencentNavKit
//
//  Created by mol on 2022/12/27.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CLLocation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 骑行面板信息
 */
@interface TNKRideNavigationData : NSObject

/**
 * @brief 下一段路名
 */
@property (nonatomic, readonly) NSString *nextRoadName;

/**
 * @brief 当前路名
 */
@property (nonatomic, readonly) NSString *currentRoadName;

/**
 * @brief 到下一段的距离 单位:米
 */
@property (nonatomic, readonly) int nextDistanceLeft;

/**
 * @brief 剩余总距离 单位:米
 */
@property (nonatomic, readonly) int totalDistanceLeft;

/**
 * @brief 剩余时间 单位:分钟
 */
@property (nonatomic, readonly) int totalTimeLeft;

/**
 * @brief 当前速度值，单位: 公里／小时 数值为负时当前速度值无效
 */
@property (nonatomic, readonly) int currentSpeed;

/**
 * @brief 当前路口转向箭头图片
 */
@property (nonatomic, readonly) UIImage *intersectionImage;

/**
 * @brief 当前路口转向类型. since 5.4.1
 */
@property (nonatomic, readonly) int intersectionType;

@end

/*------------------------------------两轮车投屏场景------------------------------------*/

@interface TNKRideNavigationBriefInfo : NSObject

/**
 * @brief 转向类型文字
 */
@property (nonatomic, copy) NSString *nextTurn;

/**
 * @brief 当前道路名称
 */
@property (nonatomic, copy) NSString *roadName;

/**
 * @brief  距离转向点（米）
 */
@property (nonatomic, assign) int distanceToTurn;

/**
 * @brief  剩余总距离（米）
 */
@property (nonatomic, assign) int totalDistance;

/**
 * @brief  剩余预计时间（秒）
 */
@property (nonatomic, assign) int estimatedTime;
@end

/**
 * @brief 骑行导航投屏信息
 */
@interface TNKRideNavigationBriefInfoData : NSObject

/**
 * @brief 当前定位.
 */
@property (nonatomic, assign) CLLocationCoordinate2D location;

/**
 * @brief 道路数据.
 */
@property (nonatomic, strong) TNKRideNavigationBriefInfo *navigation;

/**
 * @brief  语音提示文本
 */
@property (nonatomic, copy) NSString *voiceText;

/**
 * @brief  本次数据版本号
 */
@property (nonatomic, assign) int version;

/**
 * @brief  提示内容
 */
@property (nonatomic, copy) NSString *errorMessage;

@end

NS_ASSUME_NONNULL_END
