//
//  TNKRideNavView.h
//  TencentNavKit
//
//  Created by mol on 2022/10/27.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <TencentNavKit/TNKBaseNavView.h>
#import <TencentNavKit/TNKRideNavDelegate.h>
#import <TencentNavKit/TNKRideNavViewDelegate.h>
#import "TNKNavTTS.h"
#import "TNKUIComponentConfig.h"

NS_ASSUME_NONNULL_BEGIN


typedef enum _TNKRideTTSMode
{
    TNKRideTTSModeSilent  = TNKNavTTSModeSilent,   ///< 静音
    TNKRideTTSModeSpeak   = TNKNavTTSModeDefault,  ///< 播报（你想选 Default 还是 Brief 都行）
} TNKRideTTSMode;

/// 骑行导航地图类
@interface TNKRideNavView : TNKBaseNavView <TNKRideNavDelegate>

/**
 *  @brief TNKRideNavView的回调,用于接收导航模式、日夜状态等变化.
 */
@property (nonatomic, weak, nullable) id<TNKRideNavViewDelegate> delegate;

/**
 *  @brief 是否显示界面元素,默认NO。（不包含对导航面板的控制），需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showUIElements;

/**
 *  @brief 是否显示全览/退出全览切换按钮，默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showOverviewButton;

/**
 *  @brief 是否显示底部工具栏，默认NO（包含退出、剩余距离时间、预计到达时间、设置），需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showBottomToolbar;

/**
 *  @brief 是否显示提示(包括GPS变弱、恢复，手动刷新路线)，默认NO
 */
@property (nonatomic, assign) BOOL showToast;

/**
 *  @brief 是否显示路线刷新按钮，默认为NO，需在开启导航后设置. since 5.2.5
 */
@property (nonatomic, assign) BOOL showRouteRefreshButton;

/**
 *  @brief 是否显示当前车速， 默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showCurrentSpeedView;

/**
 * @brief 导航截图叠加视图
 */
@property (nonatomic, strong, nullable) UIView* navInfoBriefView;

/**
 *  @brief 是否显示设置按钮，默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showSettingButton;

/**
 *  @brief 是否显示退出按钮，默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showExitButton;

/**
 * 设置UI组件配置
 */
- (void)setUIComponentConfig:(TNKUIComponentConfig *)uiComponentConfig;


/**
 * @brief 异步截图，支持定时回调  注意:需要导航开启后设置才能生效。
 * @param config 截图参数配置对象，其中interval属性控制定时回调间隔（秒），config:nil执行停止截图.
 * @param completion 异步回调结果，会根据interval定时触发
 */
- (void)snapShotWithConfig:(TNKSnapShotConfig *)config completion:(void (^)(TNKSnapShotResult * _Nullable result, NSError * _Nullable error))completion;

/**
 * 停止截图
 */
- (void)stopSnapShot;
 
@end

NS_ASSUME_NONNULL_END
