//
//  TNKRideNavDataSource.h
//  TencentNavKit
//
//  Created by mol on 2023/3/21.
//  Copyright © 2023 Tencent. All rights reserved.
//

NS_ASSUME_NONNULL_BEGIN

@class TNKRideNavManager,
TNKNavTTS;


/// 导航特殊事件回调，需要返回值
@protocol TNKRideNavDataSource <NSObject>

@optional

/**
 * @brief 告知语音播报结果。注意: 该回调发生在导航线程中，这里不可以做耗时操作
 * @param manager manager
 * @param naviTTS tts信息
 * @return 是否播报该文案.0未播报,1已播报.
 */
- (int)rideNavManager:(TNKRideNavManager *)manager
              naviTTS:(TNKNavTTS *)naviTTS;

@end

NS_ASSUME_NONNULL_END
