//
//  TNKRerouteParam.h
//  TencentNavKit
//
//  Created by mol on 2022/11/17.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKDriveCommonObj.h>

NS_ASSUME_NONNULL_BEGIN

/// 重新算路参数基类
@interface TNKRerouteParam : NSObject

@end

/// 刷新路线参数
@interface TNKRefreshRerouteParam: TNKRerouteParam
@end

/// 主动偏航参数
@interface TNKOffCourseRerouteParam: TNKRerouteParam
@end

/// 修改目的地
@interface TNKDestinationRerouteParam : TNKRerouteParam

/// 新的目的地
@property (nonatomic, strong) TNKSearchNavPoint *destination;

@end


/// 平行路切换参数。只在驾车导航下生效
@interface TNKParallelRoadRerouteParam : TNKRerouteParam

/// 切换到的平行路类型。
@property (nonatomic, assign) TNKRoadType roadType;

@end

/// 修改途经点参数。只在驾车导航下生效
@interface TNKWaypointRerouteParam : TNKRerouteParam

/// 新的途经点列表
@property (nonatomic ,copy) NSArray<TNKSearchNavPoint *> *waypoints;

@end

/// 修改途经点与目的地参数。只在驾车导航下生效
@interface TNKDestAndWaypointRerouteParam : TNKRerouteParam

/// 新的目的地
@property (nonatomic, strong) TNKSearchNavPoint *destination;

/// 新的途经点列表
@property (nonatomic ,copy) NSArray<TNKSearchNavPoint *> *waypoints;

@end

/// 修改选路策略必要参数。只在驾车导航下生效
@interface TNKSearchPreferenceRerouteParam : TNKRerouteParam

/**
 * @brief 驾车路线规划参数: 是否避开收费道路, 默认NO, 即不避开收费道路.
 */
@property (nonatomic, assign) BOOL avoidToll;

/**
 * @brief 驾车路线规划参数: 是否避开高速道路, 默认为NO, 即不避开高速道路.
 */
@property (nonatomic, assign) BOOL avoidHighway;

/**
 * @brief 驾车路线规划参数: 是否结合路况, 默认值NO, 即不结合路况.
 */
@property (nonatomic, assign) BOOL avoidTrafficJam;

/**
 * @brief 驾车路线规划参数: 是否优先高速, 默认NO. since 5.3.3
 */
@property (nonatomic, assign) BOOL highway;

/**
 * @brief 驾车路线规划参数: 是否优先出时间短的路线, 默认为NO. since 5.3.3
 */
@property (nonatomic, assign) BOOL shortTime;

/**
 * @brief 驾车路线规划参数: 是否优先出距离短的路线, 默认为false. since 6.11.0
 */
@property (nonatomic, assign) BOOL isShortDistance;

/**
 * @brief 驾车路线规划参数: 是否优先大路, 默认值NO. since 5.3.3
 */
@property (nonatomic, assign) BOOL bigRoad;

@end

/// 路线还原必要参数。只在驾车导航下生效
@interface TNKRestoreRouteRerouteParam : TNKRerouteParam

/// 路线id，来自webservice api算路结果
@property (nonatomic ,copy) NSString *routeID;

/// 请求id，来自webservice api算路结果
@property (nonatomic, copy) NSString *requestID;

/// 新的目的地。如果目的地未变更，可不传
@property (nonatomic, strong, nullable) TNKSearchNavPoint *destination;

@end

NS_ASSUME_NONNULL_END
