//
//  TNKRecommendRouteInfo.h
//  TencentNavKit
//
//  Created by mol on 2022/5/19.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 推荐新路线信息
@interface TNKRecommendRouteInfo : NSObject

/**
 * @brief 当前路线id
 */
@property (nonatomic, copy) NSString *currentRouteID;

/**
 * @brief 推荐路线id
 */
@property (nonatomic, copy) NSString *recommendRouteID;

/**
 * @brief 推荐理由。用于弹窗展示
 */
@property (nonatomic, copy) NSString *recommendReason;

/**
 * @brief 推荐类型 recommend_type; 0-更快， 1-封路， 2-限行
 */
@property (nonatomic, assign) int  recommendType;

/**
 * @brief 播报文案。用于播报提醒
 */
@property (nonatomic, copy) NSString *broadcastText;

@end

NS_ASSUME_NONNULL_END
