//
//  TNKPosMatchLocationListener.h
//  TencentNavKit
//
//  Created by mol on 2023/11/20.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentLBS/TencentLBS.h>
#import <TencentNavKit/TNKDriveCommonObj.h>

NS_ASSUME_NONNULL_BEGIN

@protocol TNKPosMatchLocationListener <TencentLBSLocationManagerDelegate>

/**
 *  当定位发生错误时，会调用代理的此方法
 *
 *  @param manager 定位 TencentLBSLocationManager 类
 *  @param PosMatchLocation 吸附定位信息
 */
- (void)tencentLBSLocationManager:(TencentLBSLocationManager*)manager
        didUpdatePosMatchLocation:(TNKPosMatchLocation*)PosMatchLocation;

@end

NS_ASSUME_NONNULL_END
