//
//  TNKNavTTS.h
//  TencentNavKit
//
//  Created by Tencent on 2018/3/1.
//  Copyright © 2018年 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 * @brief 导航播报模式
 * 
 */
typedef enum _TNKNavTTSMode
{
    TNKNavTTSModeDefault = 0,    ///< 标准模式
    TNKNavTTSModeBrief   = 1,    ///< 简洁
    TNKNavTTSModeSilent  = 2,    ///< 静音
} TNKNavTTSMode;


//Default = 1,
//Brief = 2,
//Silent = 3,

/**
 * @brief 声音类型.
 */
typedef enum _TNKNavTTSVoiceType {
    TNKNavTTSVoiceTypeNone    = 0,
    TNKNavTTSVoiceTypeBeep    = 1,
} TNKNavTTSVoiceType;

/**
 * @brief TTS播报内容
 */
@interface TNKNavTTS : NSObject

/**
 * @brief 播报的字符串内容.
 */
@property (nonatomic, copy, nonnull) NSString *ttsString;

/**
 * @brief 声音类型.
 */
@property (nonatomic, assign) TNKNavTTSVoiceType voiceType;

/**
 * @brief 类型.
 */
@property (nonatomic, assign) int type;

@end
