//
//  TNKNavServices.h
//  TencentNavKit
//
//  Created by mol on 2022/7/26.
//  Copyright © 2022年 Tencent. All rights reserved.


#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 导航服务类.包含鉴权,获取版本号等功能
 */
@interface TNKNavServices : NSObject

/**
 * @brief 获取单例
 */
+ (TNKNavServices *)sharedServices;

/**
 * @brief 隐私合规接口, 必须在导航初始化前调用, 默认为false. since 5.3.9
 *        设置为false, 无法使用导航能力
 *        隐私政策官网: https://lbs.qq.com/userAgreements/agreements/privacy
 */
- (void)setPrivacyAgreement:(BOOL)agreed;

/**
 * @brief identifier 设备标识，默认取自idfv。排查问题时需提供此identifier。注意，卸载重装时identifier可能发生变化。
 * 如果希望使用自己业务上的设备标识来排查问题，可以将identifier修改为自己业务上的设备标识。
 */
@property (nonatomic, copy) NSString *identifier;

/**
 * @brief deviceModel 手机型号，可自定义传入
 */
@property (nonatomic, copy) NSString *deviceModel;

/**
 * @brief 在官网申请的服务授权标识的key。官网地址: https://lbs.qq.com/
 */
@property (nonatomic, copy) NSString *key;

/**
 * @brief 获取导航SDK的版本号
 */
- (NSString *)sdkVersion;

/// 域名配置
- (void)configServiceProtocol:(NSString *)protocolFilePath;

@end

NS_ASSUME_NONNULL_END
