//
//  TNKDriveNavViewDelegate.h
//  TencentNavKit
//
//  Created by mol on 2022/11/16.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKBaseNavViewDelegate.h>

NS_ASSUME_NONNULL_BEGIN


@class TNKDriveNavView,
TNKTravelNavView,
TNKBaseNavView;

/// 驾车导航地图类回调
@protocol TNKDriveNavViewDelegate <TNKBaseNavViewDelegate>

@optional

/**
 * @brief 获取导航模式改变回调.
 * @param navView 驾车地图
 * @param mode 导航模式
 */
- (void)navView:(TNKBaseNavView *)navView didChangeUIMode:(TNKNavUIMode)mode;

/**
 * @brief 获取日夜状态改变回调.
 * @param navView 驾车地图
 * @param status 日夜状态
 */
- (void)navView:(TNKBaseNavView *)navView didChangeDayNightStatus:(TNKNavDayNightStatus)status;

/**
 * @brief 点击退出按钮的回调.
 * @param navView 驾车地图
 */
- (void)navViewCloseButtonClicked:(TNKBaseNavView *)navView;

/**
 * @brief 展示路口放大图的回调
 * @since 5.2.7
 * @param  navView 驾车地图
 */
- (void)navViewDidShowEnlargedMap:(TNKBaseNavView *)navView;

/**
 * @brief 隐藏路口放大图的回调
 * @since 5.2.7
 * @param  navView 驾车地图
 */
- (void)navViewDidHideEnlargedMap:(TNKBaseNavView *)navView;

@end

NS_ASSUME_NONNULL_END
