//
//  TNKBaseNavManager.h
//  TencentNavKit
//
//  Created by mol on 2022/7/26.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKRerouteParam.h>
#import <TencentNavKit/TNKAudioPlayerProtocol.h>
#import <TencentNavKit/TNKLocationSimulator.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 途经点移除策略
 */
typedef enum _TNKWaypointRemovedStrategy
{
    /// 默认策略。到达途经点后SDK自动判达。
    TNKWaypointRemovedStrategyDefault       = 0,
    /// 开发者移除策略。达到途经点如果想要移除该途经点，需要开发者调用changeWayPoints方法重新算路
    TNKWaypointRemovedStrategyManually      = 1,
} TNKWaypointRemovedStrategy;

/// 导航管理基础类
@interface TNKBaseNavManager : NSObject

//- (instancetype)init __attribute__((unavailable("请使用各子类的sharedInstance方法， 导航管理类不再支持多实例")));;

/**
 * @brief 导航控制器是否在工作中，包含导航状态+偏航状态
 */
@property (nonatomic, readonly, getter=isRunning) BOOL running;

/**
 * @brief 导航播报的播放器。开发者如需SDK内置播报，需赋值[TNKAudioPlayer sharedAudioPlayer]对象至该属性
 */
@property (nonatomic, strong, nullable) id<TNKAudioPlayerProtocol> audioPlayer;

/**
 * @brief 定位点模拟器，用于测试。
 */
@property (nonatomic, readonly) id<TNKLocationSimulator> locationSimulator;

/**
 *  @brief 启动导航. 需要在驾车导航路线规划成功后进行.
 *  @param index 路线索引. 与路线规划返回的路线结果顺序一致.
 *  @return 是否成功
 */
- (BOOL)startNavWithIndex:(NSUInteger)index;

/**
 *  @brief 启动导航. 需要在驾车导航路线规划成功后进行.
 *  @param routeID 路线ID.
 *  @return 是否成功
 */
- (BOOL)startNavWithRouteID:(NSString *)routeID;

/**
 *  @brief 设置路径规划缓存数 [1, 8]，默认 1.
 * @since 6.7.5
 *  @param routePlanCacheSize 个数.
 *  @return 是否成功
 */
- (BOOL)setNaveRoutePlanCacheSize:(int) routePlanCacheSize;

/**
 *  @brief 结束导航.
 */
- (void)stopNav;

/**
 *  @brief 重新算路方法
 *  @param rerouteParam 重新算路参数
 */
- (void)rerouteWithParam:(TNKRerouteParam *)rerouteParam;

@end

NS_ASSUME_NONNULL_END
