//
//  TencentLBSLocationScene.h
//  TencentLBS
//
//  Created by Ranyruan on 2023/7/3.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, TencentLBSLocationSceneType) {
    TencentLBSLocationSceneUnknow                = 0,        //!< 未知状态
    TencentLBSLocationSceneTunnel                = 1,        //!< 隧道
    TencentLBSLocationSceneIndoor                = 2,        //!< 室内
    TencentLBSLocationSceneOutdoor               = 3,        //!< 室外
    TencentLBSLocationSceneUndergroundParking    = 4,        //!< 地库
    TencentLBSLocationSceneGnssError             = 5,        //!< gnss error
};

typedef NS_ENUM(NSUInteger, TencentLBSSceneUnkownFrom) {
    TencentLBSSceneUnkownFromTunnel = 1, //!< 出隧道的unkown
    TencentLBSSceneUnkownFromInOut  = 2, //!< 室内外判断的unkown
};

@interface TencentLBSLocationScene : NSObject<NSCopying>

@property (assign, nonatomic, readwrite)TencentLBSLocationSceneType locationScene;

@property (strong, nonatomic, readwrite)NSDictionary *extraInfo;

/**
 * 外部无需关心
 */
@property (assign, nonatomic, readwrite)TencentLBSSceneUnkownFrom unkownFrom;

@end

NS_ASSUME_NONNULL_END
