//
//  TencentLBSLocationConfig.h
//  TencentLBS
//
//  Created by fengli ruan on 2020/6/2.
//  Copyright © 2020 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSInteger, TencentLBSLocType) {
    TencentLBSLocTypeUnknown = -1,              //!< 未知
    TencentLBSLocTypeGNSS = 0,                  //!< 纯GPS定位模式
    TencentLBSLocTypeDrBack = 1,                //!< DrEngine模式(后端融合)
    TencentLBSLocTypeDrFront = 2,               //!< DrEngine模式(前端融合)
    TencentLBSLocTypeVDR = 3,                   //!< VDR定位模式
};

/**
* @brief 视觉信号类型
* @see   LocModeType
*/
typedef NS_ENUM(NSInteger, TencentLBSVisionPlatformType) {
    TencentLBSVisTypeNone = 0,                  /**< 无视觉或未定义 */
    TencentLBSVisTypeTencent = 1,               /**< 自研视觉方案 */
    TencentLBSVisTypeHorizon = 2,               /**< 地平线方案 */
};

typedef NS_OPTIONS(NSUInteger, TencentLBSLocationFunctionsFlag) {
    LocFuncViaductRecognize = 1 << 0,       //!< 【巡航】 高架功能。         所有模式默认不开启
    LocFuncParallelRecognize = 1 << 1,      //!< 【巡航】 平行路/主辅路识别。纯GNSS、前端融合默认不开启，具备三轴陀螺仪的后端融合默认开启
    LocFuncMainSideRoadDecision = 1 << 2,   //!< 【巡航】 主辅路决策插件。   纯GNSS、前端融合默认开启，后端融合默认不开启
    LocFuncAbsolutePosCorrection = 1 << 3,  //!< 【巡航】 绝对位置纠错。     纯GNSS、前端融合默认不开启，后端融合默认开启
    LocFuncDivergingPathsRecognize = 1 << 4,//!< 【巡航】 分岔路识别。       纯GNSS、前端融合默认不开启，具备三轴陀螺仪的后端融合默认开启
    LocFuncTurningSmooth = 1 << 5,          //!< 【巡航】 转弯平滑。         纯GNSS、前端融合默认不开启，后端融合默认开启
    LocFuncDelayTurningLowSpeed = 1 << 6,   //!< 【巡航】 极低速延迟转弯。   纯GNSS默认开启，前端、后端融合默认不开启
    LocFuncTurningMainSideRoad = 1 << 7,    //!< 【巡航】 转弯进主辅路。     纯GNSS、前端融合默认不开启，后端融合默认开启
    LocFuncUTurnMatch = 1 << 8,             //!< 【巡航】 掉头匹配。         纯GNSS、前端融合默认不开启，后端融合默认开启
    LocFuncForkQuickCorrection = 1 << 9,    //!< 【巡航】 分岔路快速纠错。   纯GNSS默认不开启，前端融合默认开启，后端融合默认不开启
    LocFuncConfusingTurning = 1 << 10,      //!< 【巡航】 左转、掉头混淆。   纯GNSS、前端融合默认开启，后端融合默认不开启
    LocFuncTunnelCorrection = 1 << 11,      //!< 【巡航】 隧道纠错。         所有模式默认不开启
    LocFuncLeaveRoundabout = 1 << 12,       //!< 【巡航】 抑制出环岛。       纯GNSS、前端融合模式始终开启，不受开关控制，后端融合模式默认开启
};
@interface TencentLBSResourceConfig : NSObject
/**
 * 定位上下文保存目录
 */
@property (nonatomic,readwrite,copy) NSString *locConfigPath;

/**
 * 商定为idfv，内部赋值，外部忽略
 */
@property (nonatomic,readwrite,copy) NSString *imei;

/**
 * 外部赋值
 */
@property (nonatomic,readwrite,copy) NSString *qimei;

/**
 * 内部赋值，外部忽略
 */
@property (nonatomic,readwrite,copy) NSString *yunxi_db_path;

/**
 * 内部赋值，外部忽略
 */
@property (nonatomic,readwrite,copy) NSString *device_models;

-(instancetype)initWithLocConfigPath:(NSString *) locConfigPath;
@end

@interface TencentLBSLocMountAngle : NSObject
@property (nonatomic,readwrite,assign) BOOL isValid;
@property (nonatomic,readwrite,assign) double yaw;
@property (nonatomic,readwrite,assign) double pitch;
@property (nonatomic,readwrite,assign) double roll;

-(instancetype)initWithIsValid:(BOOL)isValid
                       withYaw:(double)yaw
                     withPitch:(double)pitch
                      withRoll:(double)roll;
@end

@interface TencentLBSLocSensorOption : NSObject
/**
 * 加速度计轴数。值：{0|1|3}， 0 表示没有
 **/
@property (nonatomic,readwrite,assign) int hasAcc;
/**
 * 陀螺仪轴数。值：{0|1|3} ， 0 表示没有
 **/
@property (nonatomic,readwrite,assign) int hasGyro;
/**
 * 有无陀螺温度传感器 0:无; 1:有
 **/
@property (nonatomic,readwrite,assign) int hasTemp;
/**
 * 有无气压计 0:无; 1:有
 **/
@property (nonatomic,readwrite,assign) int hasPressure;
/**
 * 有无磁力计 0:无; 1:有
 **/
@property (nonatomic,readwrite,assign) int hasMag;
/**
 * 有无四轮速传感器 0:无; 1:有
 **/
@property (nonatomic,readwrite,assign) int hasW4m;
/**
 * 有无GSV信息（星历信息）， 0无 1有
 **/
@property (nonatomic,readwrite,assign) int hasGsv;
/**
 * 脉冲信息输入频率。@note 单位：Hz
 **/
@property (nonatomic,readwrite,assign) int pulseFreq;
/**
 * 陀螺仪信息输入频率。@note 单位：Hz
 **/
@property (nonatomic,readwrite,assign) int gyroFreq;
/**
 * GNSS信息输入频率。@note 单位；Hz
 **/
@property (nonatomic,readwrite,assign) int gpsFreq;
/**
 * 加速度计信息输入频率。@note 单位；Hz
 **/
@property (nonatomic,readwrite,assign) int accFreq;
/**
 * 四轮速信息输信息入频率。@note 单位；Hz
 **/
@property (nonatomic,readwrite,assign) int w4mFreq;
-(instancetype)initWtihHasAcc:(int)hasAcc
                  withHasGyro:(int)hasGyro
                  withHasTemp:(int)hasTemp
              withHasPressure:(int)hasPressure
                   withHasMag:(int)hasMag
                   withHasW4m:(int)hasW4m
                   withHasGsv:(int)hasGsv
                withPulseFreq:(int)pulseFreq
                 withGyroFreq:(int)gyroFreq
                  withGpsFreq:(int)gpsFreq
                  withAccFreq:(int)accFreq
                  withW4mFreq:(int)w4mFreq;
@end


@interface TencentLBSLocationPreference : NSObject
/**
* 开启的功能 init value: 0
**/
@property (nonatomic,readwrite,assign) TencentLBSLocationFunctionsFlag funcs;
/**
* 输入的信号类型 init value: 0
**/
@property (nonatomic,readwrite,assign) int signalTypes;
/**
* 定位模式 init value: ELocationTypeNONE
**/
@property (nonatomic,readwrite,assign) TencentLBSLocType locType;

/**
 * 视觉方案类型 0 未使用 1 自研 1 地平线
 */
@property (nonatomic,readwrite,assign) TencentLBSVisionPlatformType visType;

/**
* 安装角
**/
@property (nonatomic,readwrite,strong) TencentLBSLocMountAngle *mountAngle;
/**
* 传感器参数
**/
@property (nonatomic,readwrite,strong) TencentLBSLocSensorOption *sensorOption;
-(instancetype)initWithFuncs:(TencentLBSLocationFunctionsFlag)funcs
                 withLocType:(TencentLBSLocType)locType
                 withVisType:(TencentLBSVisionPlatformType)visType
           withLocMountAngle:(TencentLBSLocMountAngle *)mountAngle
         withLocSensorOption:(TencentLBSLocSensorOption *)sensorOption;
@end
@interface TencentLBSLocationConfig : NSObject
/**
@brief ResourceConfig 配置项
@see TencentLBSResourceConfig
 **/
@property (nonatomic,readwrite,strong)TencentLBSResourceConfig *resConfig;
/**
@brief LocationPreference 配置项
@see TencentLBSLocationPreference
**/
@property (nonatomic,readwrite,strong)TencentLBSLocationPreference *locationPreference;
@end

NS_ASSUME_NONNULL_END
