//
//  TencentLBSGuideArea.h
//  TencentLBS
//
//  Created by fengli ruan on 2021/12/1.
//  Copyright © 2021 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,TencentLBSGroupSourceType){
    TencentLBS_GROUP_SOURCE_TYPE_UNKOWN = -1,
    TencentLBS_GROUP_SOURCE_TYPE_HD = 0,
    TencentLBS_GROUP_SOURCE_TYPE_4K = 1,
    TencentLBS_GROUP_SOURCE_TYPE_HD_AIR = 2
};


@interface TencentLBSBoundaryLane : NSObject

@property (nonatomic, assign)uint32_t tile_id;
@property (nonatomic, assign)uint32_t lane_id;
@property (nonatomic, assign)double start_ratio; // 起点对应laneGroup比例
@property (nonatomic, assign)double end_ratio;   // 终点对应laneGroup比例

@end

@interface TencentLBSLaneGroupMapping : NSObject

@property (nonatomic, assign)uint32_t tileId;
@property (nonatomic, assign)uint32_t laneGroupId;
/**
 * LaneGroup起点对应中心线形点索引
 */
@property (nonatomic, assign)int startCenterIndex;
/**
 * LaneGroup终点对应中心线形点索引
 */
@property (nonatomic, assign)int endCenterIndex;
/**
 * LaneGroup起点对应SD路线形点索引
 */
@property (nonatomic, assign)int startRouteLineIndex;
/**
 * LaneGroup起点对应SD路线形点偏移（单位：米）
 */
@property (nonatomic, assign)double startRouteLineOffset;
/**
 * LaneGroup终点对应SD路线形点索引
 */
@property (nonatomic, assign)int endRouteLineIndex;
/**
 * LaneGroup终点对应SD路线形点偏移（单位：米）
 */
@property (nonatomic, assign)double endRouteLineOffset;

/**
 * group data 数据源
 */
@property (nonatomic, assign)TencentLBSGroupSourceType groupSourceType;

/**
 * LaneGroup引导面最左边界线车道信息
 */
@property (nonatomic, readwrite, strong)NSArray<TencentLBSBoundaryLane *> *leftBoundaryLanes;

/**
 * LaneGroup引导面最右边界线车道信息
 */
@property (nonatomic, readwrite, strong)NSArray<TencentLBSBoundaryLane *> *rightBoundaryLanes;

@end

@interface TencentLBSGeoCoordinateZ : NSObject
/**
 * 经度，小数点后6位
 */
@property (nonatomic, assign)double lng;

/**
 * 纬度，小数点后6位
 */
@property (nonatomic, assign)double lat;

/**
 * 获取高程，单位厘米
 */
@property (nonatomic, assign)float z;

@end

@interface TencentLBSGuideArea : NSObject
/**
 * 系统开机时间 单位ms
 */
@property (nonatomic, assign)int64_t tickTime;

/**
 * 路线ID
 */
@property (nonatomic, readwrite, copy)NSString *routeId;

/**
 * 代表引导面数据是否连续
 * @return 0 不连续，1 连续
 */
@property (nonatomic, assign)int32_t indexOffset;

/**
 * 获取引导面经纬度及高程信息集合
 * @return
 */
@property (nonatomic, readwrite, strong)NSMutableArray<TencentLBSGeoCoordinateZ *> * coordinateZGroup;

/**
 * 引导面ID
 */
@property (nonatomic, readwrite, copy)NSString *guideArea_id;


/**
 * 引导面类型，0：高精引导面，1：4K引导面
 */
@property (nonatomic, assign)int32_t guideArea_type;

/**
 * 获取引导面LaneGroup映射关系
 */
@property (nonatomic, readwrite, strong)NSArray<TencentLBSLaneGroupMapping *> *laneGroupMapping;

/**
 * 引导面批次id
 */
@property (nonatomic, assign)int32_t batch_id;

/**
 * hd数据版本号
 */
@property (nonatomic, assign)int32_t hd_version_id;

@end

NS_ASSUME_NONNULL_END
