//
//  QMarkerViewAnimationLayer.h
//  QMapKit
//
//  Created by KeithCao on 2024/5/29.
//  Copyright © 2024 tencent. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * 坐标点点动画对应的key.
 */
extern NSString *const kQMarkerViewAnimationLayerCoordinateKey;

/**
 * alpha动画对应的key.
 */
extern NSString *const kQMarkerViewAnimationLayerAlphaKey;

/**
 * 旋转动画对应的key.
 */
extern NSString *const kQMarkerViewAnimationLayerRotationKey;

/**
 * scale动画对应的key.
 */
extern NSString *const kQMarkerViewAnimationLayerScaleKey;


@interface QMarkerViewAnimationLayer : CALayer

/**
 *  @brief  坐标平移动画的keyPath, animatable
 *   x 表示 latitude
 *   y 表示 longitude
 */
@property (nonatomic, assign) CGPoint coordinate;

/**
 *  @brief  渐变动画的keyPath, animatable
 */
@property (nonatomic, assign) CGFloat alpha;

/**
 *  @brief  旋转角度动画的keyPath, animatable
 */
@property (nonatomic, assign) CGFloat rotation;

/**
 *  @brief  缩放动画的keyPath, animatable
 *   x 表示 宽度比例
 *   y 表示 高度比例
 */
@property (nonatomic, assign) CGPoint scale;

@end

NS_ASSUME_NONNULL_END
