//
//  TNKWalkNavigationData.h
//  TencentNavKit
//
//  Created by mol on 2023/1/9.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 步行面板信息
 */
@interface TNKWalkNavigationData : NSObject

/**
 * @brief 下一段路名
 */
@property (nonatomic, readonly) NSString *nextRoadName;

/**
 * @brief 当前路名
 */
@property (nonatomic, readonly) NSString *currentRoadName;

/**
 * @brief 到下一段的距离 单位:米
 */
@property (nonatomic, readonly) int nextDistanceLeft;

/**
 * @brief 剩余总距离 单位:米
 */
@property (nonatomic, readonly) int totalDistanceLeft;

/**
 * @brief 剩余时间 单位:分钟
 */
@property (nonatomic, readonly) int totalTimeLeft;

/**
 * @brief 当前速度值，单位: 公里／小时 数值为负时当前速度值无效
 */
@property (nonatomic, readonly) int currentSpeed;;

/**
 * @brief 当前路口转向箭头图片
 */
@property (nonatomic, readonly) UIImage *intersectionImage;

/**
 * @brief 当前路口转向类型. since 5.4.1
 */
@property (nonatomic, readonly) int intersectionType;

@end

NS_ASSUME_NONNULL_END
