//
//  TNKTurnArrowConfig.h
//  TencentNavKit
//
//  Created by mol on 2023/3/14.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/// 转向箭头样式
@interface TNKTurnArrowConfig : NSObject

/// 是否隐藏路线上的转向箭头，默认为NO
@property (nonatomic, assign) BOOL hidden;
/// 箭头颜色
@property (nonatomic, strong) UIColor *arrowColor;
/// 描边颜色
@property (nonatomic, strong) UIColor *borderColor;
/// 阴影颜色
@property (nonatomic, strong) UIColor *shadowColor;
// 是否为3D箭头，默认为YES
@property (nonatomic, assign) BOOL is3D;
// 箭头宽度与路线宽度的比值，默认为1
@property (nonatomic, assign) CGFloat widthScale;

@end

NS_ASSUME_NONNULL_END
