//
//  TNKTrafficJamInfo.h
//  TencentNavKit
//
//  Created by mol on 2023/3/14.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKDriveCommonObj.h>
#import <TencentNavKit/TNKRouteTrafficItem.h>

NS_ASSUME_NONNULL_BEGIN

/// 前方拥堵信息
@interface TNKTrafficJamInfo : NSObject
/// 拥堵时间，单位秒
@property (nonatomic, readonly) int jamDuration;
/// 拥堵长度，单位米
@property (nonatomic, readonly) int jamDistance;
/// 是否在拥堵路段内
@property (nonatomic, readonly) BOOL inJamArea;
/// 拥堵状态
@property (nonatomic, readonly) TNKRouteTrafficDataStatus trafficStatus;

@property (nonatomic, readonly) NSArray<TNKRoutePoint *> * routePoints;

@end

NS_ASSUME_NONNULL_END
