//
//  TNKRideNavManager.h
//  TencentNavKit
//
//  Created by mol on 2022/10/27.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <TencentNavKit/TNKBaseNavManager.h>
#import <TencentNavKit/TNKRideCommonObj.h>
#import <TencentNavKit/TNKRideNavDelegate.h>
#import <TencentNavKit/TNKSearchTask.h>
#import <TencentNavKit/TNKRideNavDataSource.h>

NS_ASSUME_NONNULL_BEGIN
 
typedef enum _TNKRideVehicleType
{
    TNKRideVehicleTypeBike  = 1,    ///< 自行车，骑行工具
    TNKRideVehicleTypeEBike = 2,    ///< 电动自行车，骑行工具
} TNKRideVehicleType;

/// 骑行导航管理类
@interface TNKRideNavManager : TNKBaseNavManager

/// 单例模式，获取导航管理对象
+ (instancetype)sharedInstance;

/**
 *  @brief 当前正在导航时的主路线数据。非导航时为nil
 */
@property (nonatomic, readonly, nullable) TNKRideNavRoute *curNavRoute;


/**
 * @brief 导航播报模式，默认为标准模式.
 * @since 5.3.9
 */
@property (nonatomic, assign) TNKNavTTSMode ttsMode;

/**
 * @brief 导航事件DataSource. since 5.2.6
 */
@property (nonatomic, weak, nullable) id<TNKRideNavDataSource> navDataSource;

/**
 * @brief 骑行工具类型,传递错误值无效,默认bike. since 6.10.2
 */
@property (nonatomic, assign) TNKRideVehicleType vehicleType;

/**
 * @brief 注册对象接收导航事件变化.
 *  注册后可通过该协议获取导航过程中出现的状态或信息改变(如已偏航、经过途经点、到达终点等).
 *  导航事件变化采用广播形式,可同时注册多个对象接收事件变化.
 * @warning 内部对navDelegate弱持有
 * @param navDelegate 接收导航事件变化的对象
 */
- (void)registerNavDelegate:(id<TNKRideNavDelegate>)navDelegate;

/**
 * @brief 注销对象接收导航事件变化.
 * @param navDelegate 接收导航事件变化的对象
 */
- (void)unregisterNavDelegate:(id<TNKRideNavDelegate>)navDelegate;

/**
 * @brief 注销所有对象接收导航事件变化.
 */
- (void)unregisterAllNavDelegates;



/// 路径规划
/// @param request 请求参数
/// @param completion 回调
- (TNKSearchTask * _Nullable)searchRoutesWithRequest:(TNKRouteRequest *)request
                                          completion:(void (^)(TNKRideRouteSearchResult * _Nullable searchResult,
                                                               NSError * _Nullable error))completion;


@end

NS_ASSUME_NONNULL_END
