//
//  TNKRideNavDelegate.h
//  TencentNavKit
//
//  Created by mol on 2022/12/27.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKRerouteCommon.h>

NS_ASSUME_NONNULL_BEGIN

@class TNKRideNavManager,
TNKLocation,
TNKGpsStatus,
TNKRideNavRoute,
TNKRideRoute,
TNKRideNavigationData;


/// 骑行导航地图回调
@protocol TNKRideNavDelegate <NSObject>

@optional
/**
 * @brief 导航开始.
 * @param manager manager
 */
- (void)rideNavManagerDidStart:(TNKRideNavManager *)manager;

/**
 * @brief 导航结束.
 * @param manager manager
 */
- (void)rideNavManagerDidStop:(TNKRideNavManager *)manager;

/**
 * @brief 获取到达终点附近的回调. 尚未结束导航时, 这个回调可能执行多次.
 * @param manager manager
 */
- (void)rideNavManagerWillArriveDestination:(TNKRideNavManager *)manager;

/**
 * @brief 获取导航面板信息
 * @param manager manager
 * @param navigationData 导航面板信息
 */
- (void)rideNavManager:(TNKRideNavManager *)manager updateNavigationData:(TNKRideNavigationData *)navigationData;

/**
 * @brief 获取导航定位更新回调.
 * @param manager manager
 * @param location 定位信息
 */
- (void)rideNavManager:(TNKRideNavManager *)manager
      didUpdateLocation:(TNKLocation *)location;

/**
 * @brief 获取定位失败的回调
 * @param manager manager
 * @param error 错误信息
 */
- (void)rideNavManager:(TNKRideNavManager *)manager updateLocationFailedWithError:(NSError *)error;

/**
 * @brief 获取GPS信号状态变化的回调.
 * @param manager manager
 * @param gpsStatus gps信号状态
 */
- (void)rideNavManager:(TNKRideNavManager *)manager gpsStatusDidChange:(TNKGpsStatus *)gpsStatus;


/**
 * @brief 获取重新算路请求开始回调.
 * @param manager manager
 * @param rerouteReason 重新算路类型
 */
- (void)rideNavManager:(TNKRideNavManager *)manager didStartRerouting:(TNKRerouteReason)rerouteReason;

/**
 * @brief 获取重新算路请求成功回调.
 * @param manager manager
 * @param rerouteresult 重新算路成功结果
 */
- (void)rideNavManager:(TNKRideNavManager *)manager
      rerouteDidSuccess:(TNKRideRerouteResult *)rerouteresult;

/**
 * @brief 获取重新算路请求失败回调.
 * @param manager manager
 * @param rerouteresult 重新算路成功结果
 */
- (void)rideNavManager:(TNKRideNavManager *)manager
         rerouteDidFail:(TNKRideRerouteResult *)rerouteresult;
@end

NS_ASSUME_NONNULL_END
