//
//  TNKNavToWayPointInfo.h
//  TencentNavKit
//
//  Created by mol on 2022/11/11.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CLLocation.h>

NS_ASSUME_NONNULL_BEGIN

@class TNKSearchNavPoint;

/**
 * @brief 路线规划返回的途径点类型
*/
@interface TNKNavToWayPointInfo : NSObject

/**
 * @brief 请求参数中的途经点数据
 */
@property (nonatomic, strong) TNKSearchNavPoint *origSearchPoint;

/**
 * @brief 吸附的坐标.
 */
@property (nonatomic, assign) CLLocationCoordinate2D coordinate;

/**
 * @brief 途径点所在路线的索引
*/
@property (nonatomic, assign) int wayPointIndex;

/**
 * @brief 当前位置到途径点剩余距离， 单位：米
*/
@property (nonatomic, assign) int remainingDistance;

/**
 * @brief 当前位置到途径点剩余时间，单位：分钟
 */
@property (nonatomic, assign) int remainingTime;

/**
 * @brief 导航中第几个途经点。
 * @since 5.4.3
 */
@property (nonatomic, assign) int idx;


@end

NS_ASSUME_NONNULL_END
