//
//  TNKDriveNavView.h
//  TencentNavKit
//
//  Created by mol on 2022/8/2.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <TencentNavKit/TNKBaseNavView.h>
#import <TencentNavKit/TNKDriveNavDelegate.h>
#import <TencentNavKit/TNKDriveNavViewDelegate.h>
#import <TencentNavKit/TNKWaypointMarkerPresentation.h>
#import <TencentNavKit/TNKNaviTrafficBarWidget.h>
#import <TencentNavKit/TNKEnlargedMapConfig.h>
#import <TencentNavKit/TNKUIComponentConfig.h>

NS_ASSUME_NONNULL_BEGIN

/// 驾车导航地图类
@interface TNKDriveNavView : TNKBaseNavView<TNKDriveNavDelegate>

/**
 *  @brief TNKDriveNavView的回调,用于接收导航模式、日夜状态等变化.
 */
@property (nonatomic, weak, nullable) id<TNKDriveNavViewDelegate> delegate;


//****************    导航界面元素控制-开始    ****************//

/**
 * @brief 导航面板顶部空隙距离. 默认为全屏状态下避开状态栏. 取值范围为[0,100].
 */
@property (nonatomic, assign) NSUInteger panelTopGap;

/**
 * @brief 设置导航面板顶部空隙距离. 默认为全屏状态下避开状态栏. 取值范围为[0,100]. since 7.0.0
 */
- (TNKDriveNavView *(^)(NSUInteger))withPanelTopGap;

/**
 *  @brief 是否展示顶部导航面板, 默认为YES
 */
@property (nonatomic, assign) BOOL navigationPanelEnabled;

/**
 *  @brief 设置是否展示顶部导航面板, 默认为YES  since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withNavigationPanelEnabled;

/**
 *  @brief 设置在3D车头朝上和2D地图朝北模式下 显示/隐藏路口车道线. 默认为YES
 *         注意不管此参数如何设置，在全览模式和剩余全览模式下都会隐藏.
 */
@property (nonatomic, assign) BOOL guidedLaneEnabled;

/**
 *  @brief 设置显示/隐藏路口车道线. 默认为YES  since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withGuidedLaneEnabled;

/**
 *  @brief 是否显示界面元素,默认NO。（不包含对导航面板的控制），需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showUIElements;

/**
 *  @brief 设置是否显示界面元素,默认NO。（不包含对导航面板的控制）since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowUIElements;

/**
 *  @brief 是否显示底部工具栏，默认NO（包含退出、剩余距离时间、预计到达时间、设置），需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showBottomToolbar;

/**
 *  @brief 设置是否显示底部工具栏，默认NO（包含退出、剩余距离时间、预计到达时间、设置）since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowBottomToolbar;

/**
 *  @brief 是否显示提示(包括GPS变弱、恢复，切换路线成功，手动刷新路线)，默认NO
 */
@property (nonatomic, assign) BOOL showToast;

/**
 *  @brief 设置是否显示提示(包括GPS变弱、恢复，切换路线成功，手动刷新路线)，默认NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowToast;

/**
 *  @brief 是否显示当前车速， 默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showCurrentSpeedView;

/**
 *  @brief 设置是否显示当前车速， 默认NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowCurrentSpeedView;

/**
 *  @brief 是否展示严重超速视图，默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showGrossSpeedingView;

/**
 *  @brief 设置是否展示严重超速视图，默认NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowGrossSpeedingView;

/**
 *  @brief 是否显示路况光柱图，默认NO，从7.0开始，光柱图默认是显示在下面的BottomToolbar上的（水平显示），需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showTrafficBar;

/**
 *  @brief 设置是否显示路况光柱图，默认NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowTrafficBar;

/**
 *  @brief 光柱图实例，当showTrafficBar为YES时才不为空
 */
@property (nonatomic, readonly, nullable) TNKNaviTrafficBarWidget *trafficBar;

/**
 *  @brief 是否显示主辅路切换按钮，默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showRoadTypeButton;

/**
 *  @brief 设置是否显示主辅路切换按钮，默认NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowRoadTypeButton;

/**
 *  @brief 是否显示限速、当前路名， 默认NO
 */
@property (nonatomic, assign) BOOL showLimitSpeedAndCurrentRoadNameView;

/**
 *  @brief 设置是否显示限速、当前路名， 默认NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowLimitSpeedAndCurrentRoadNameView;

/**
 * @brief 是否显示智能定位. 默认NO. since 5.2.2
 */
@property (nonatomic, assign) BOOL showSmartLocView;

/**
 * @brief 设置是否显示智能定位. 默认NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowSmartLocView;

/**
 *  @brief 是否显示全览/退出全览切换按钮，默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showOverviewButton;

/**
 *  @brief 设置是否显示全览/退出全览切换按钮，默认NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowOverviewButton;

/**
 *  @brief 是否显示路线刷新按钮，默认为NO，需在开启导航后设置. since 5.2.5
 */
@property (nonatomic, assign) BOOL showRouteRefreshButton;

/**
 *  @brief 设置是否显示路线刷新按钮，默认为NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowRouteRefreshButton;

/**
 *  @brief 是否显示切换实时路况的按钮,默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showMapTrafficButton;

/**
 *  @brief 是否显示切换实时路况的按钮,默认NO. since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowMapTrafficButton;

/**
 *  @brief 是否显示语音播报按钮,默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showBroadCastButton;

/**
 *  @brief 是否显示语音播报按钮,默认NO since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowBroadCastButton;

/**
 *  @brief 是否显示高速休息区信息，默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showServiceAreaInfo;


/**
 *  @brief 是否显示设置按钮，默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showSettingButton;

/**
 *  @brief 是否显示设置按钮，链式调用，默认NO
 */
- (TNKDriveNavView *(^)(BOOL))withShowSettingButton;


/**
 *  @brief 是否显示退出按钮，默认NO，需在开启导航后设置
 */
@property (nonatomic, assign) BOOL showExitButton;

/**
 *  @brief 是否显示退出按钮，链式调用，默认NO
 */
- (TNKDriveNavView *(^)(BOOL))withShowExitButton;


/**
 *  @brief 是否显示高速休息区信息，默认NO since 7.0.0
 */
- (TNKDriveNavView *(^)(BOOL))withShowServiceAreaInfo;



/**
 *  @brief 是否显示界面元素,默认NO。（不包含对导航面板的控制）since 7.0.0
 */
- (void)setAllComponentVisibility:(BOOL)visible;

/**
 *  @brief builder模式构建方法 since 7.0.0
 *  @return TNKDriveNavView
 */
- (TNKDriveNavView *(^)(void))build;

/**
 * 设置UI组件配置
 */
- (void)setUIComponentConfig:(TNKUIComponentConfig *)uiComponentConfig;

/**
 * 获取UI组件配置
 */
- (TNKUIComponentConfig *)getUIComponentConfig;

//****************    导航界面元素控制-结束    ****************//


/**
 * @brief 设置导航地图是否开启自动缩放比例尺功能，默认开启。
 *        开启之后，3D车头朝上、2D地图朝北模式会在路口处自动调整地图zoomlevel和overlooking，以提供最佳视野通过路口。
 * @since 5.2.5
 */
@property (nonatomic, getter=isAutoScaleEnabled) BOOL autoScaleEnabled;

/**
 * @brief 自动缩放比例尺功能中，可设置最小zoomlevel，默认15， 取值范围[14, 17] 。
 * @since 5.2.9.6
 */
@property (nonatomic, assign) CGFloat autoScaleMinZoomLevel;

/**
 * @brief 设置导航地图是否显示实时路况,不影响showMapTrafficButton的逻辑，默认为YES。
 */
@property (nonatomic, assign) BOOL showTraffic;

/**
 * @brief 是否显示建筑物样式为3D效果，默认为NO。
 */
@property (nonatomic, assign) BOOL shows3DBuildings;

/**
 * @brief 是否隐藏路线上的红绿灯，默认为NO。
 * @since 5.4.0.6
 */
@property (nonatomic, assign) BOOL routeTrafficLightHidden;

/**
 * @brief 是否隐藏路线上的红绿灯倒计时，默认为NO。
 * @since 6.13.0
 */
@property (nonatomic, assign) BOOL lightCountDownTimerHidden;

/**
 *  @brief 设置隐藏备选路线上的气泡，默认为NO;
 */
@property (nonatomic, assign) BOOL backupRouteBubbleHidden;

/**
 *  @brief 设置是否展示路线上的电子眼.默认值为YES。
 *         电子眼标识在3D车头朝上和2D地图朝北模式下会默认显示, 在全览模式和剩余全览模式下会隐藏.
 */
@property (nonatomic, assign) BOOL cameraMarkerEnabled;

/**
 * @brief 电子眼上是否展示剩余距离。默认为NO
 * @since 6.0.0
 */
@property (nonatomic, assign) BOOL showDistanceOnCamera;

/**
 *  @brief 设置显示/隐藏路况气泡.该方法用于导航状态下控制显示/隐藏导航路线上的路况气泡. 默认为YES
 *         路况气泡在3D车头朝上和2D地图朝北模式下会显示, 在全览模式和剩余全览模式下会隐藏.
 *  @since 5.2.5
 */
@property (nonatomic, assign) BOOL trafficBubbleEnabled;

/**
 * @brief 放大图相关配置
 * @since 6.2.0
 */
@property (nonatomic, readonly) TNKEnlargedMapConfig *enlargedMapConfig;


/**
 * @brief 更新放大图配置
 * @param enlargedMapConfig 放大图配置，不可为nil
 * @since 6.2.0
 */
- (void)updateEnlargedMapConfig:(TNKEnlargedMapConfig *)enlargedMapConfig;

/**
 * @brief 移除本次展示的路口放大图.
 * @since 6.0.0
 */
- (void)removeCurrentEnlargedMap;

/**
 *  @brief 配置途径点UI属性. 该方法用于配置导航时途径点UI属性, 非导航时进行配置会在导航发起后生效。
 *         key为路径规划时设置的途经点的唯一标识，即TNKSearchNaviPoi的searchUID。
 *         入参设置为nil时，使用默认的途经点资源图片
 *  @since 6.0.0
 *  @param waypointMarkerPresentationDictionary 途经点样式
 */
- (void)updateWaypointMarkerPresentation:(NSDictionary<NSString *, TNKWaypointMarkerPresentation *> * _Nullable)waypointMarkerPresentationDictionary;

/**
 * @brief 设置是否隐藏备选路线，默认为NO。
 *        当backupRouteIDs传入数值，则展示隐藏操作作用于具体的路线；当backupRouteIDs为空时，则展示隐藏操作作用于当前以及以后的伴随路线
 * @param hidden 是否隐藏备选路线
 * @param backupRouteIDs 需要操作的备选路线id数组
 */
- (void)setBackupRoutesHidden:(BOOL)hidden backupRouteIDs:(NSArray<NSString *> * _Nullable)backupRouteIDs;

@end

NS_ASSUME_NONNULL_END
