//
//  TencentLBSMatchLocationInfo.h
//  TencentLBS
//
//  Created by fengli ruan on 2020/6/2.
//  Copyright © 2020 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import "TencentLBSLocation.h"
NS_ASSUME_NONNULL_BEGIN
@interface TencentLBSMatchLocationInfo : NSObject
/**
 *@brief 吸附结果的句柄，无需释放
 */
@property (readonly) void *matchLocationInfo;
/**
 *@brief lbsLocation,返回最新的定位SDK的结果，上层建议做一次判空处理
 *@see TencentLBSLocation
 */
@property (nonatomic, readonly, strong) TencentLBSLocation *lbsLocation;
/**
* @brief 构造一个对象
* @param location 外部传入的吸附点，其中时间戳为秒，course为路线的方向，其他正常赋值
* @param routeId 路线id
*/
-(instancetype)initWithLocation:(CLLocation *)location
                     withRoutId:(NSString *)routeId;
@end

NS_ASSUME_NONNULL_END
