//
//  TencentLBSLocationAdapter.h
//  TencentLBS
//
//  Created by fengli ruan on 2020/6/1.
//  Copyright © 2020 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import "TencentLBSLocationConfig.h"
#import "TencentLBSMatchLocationInfo.h"
#import "TencentLBSHighFreqLocInfo.h"
#import "TencentLBSGuideArea.h"
#import "TencentLBSLocationScene.h"
NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSUInteger, TencentLBSLogLevel) {
    TencentLBSLogLevelNoLog = 0,
    TencentLBSLogLevel_1 = 1,
    TencentLBSLogLevel_2 = 2,
    TencentLBSLogLevel_3 = 3,
    TencentLBSLogLevel_4 = 4,
    TencentLBSLogLevel_5 = 5,
    TencentLBSLogLevel_6 = 6,
};
/**
 *  TencentLBSPosMatchResultBlock routeMatch结果回调的Block
 *  直接返回结果的指针，使用时需要引入mapbase中的/mapbase/common/pos_result_define.h,强制转成MatchLocationInfo*类型
 *  此回调中不允许做耗时操作，该内存不需要释放，该类需要使用object-c++编译，使用时需要将文件名改为.mm
 *  @param  matchLocationInfo 结果信息
 *
 */
typedef void(^TencentLBSPosMatchResultBlock)(TencentLBSMatchLocationInfo *matchLocationInfo);

/**
 *  TencentLBSHighFreqLocBlock 结果回调的Block
 *  直接返回结果的指针，使用时需要引入mapbase中的/mapbase/common/pos_result_define.h,强制转成HighFreqLocInfo*类型
 *  此回调中不允许做耗时操作，该内存不需要释放，该类需要使用object-c++编译，使用时需要将文件名改为.mm
 *  @param  ocHighFreqLocInfo 结果信息
 *
 */
typedef void(^TencentLBSHighFreqLocBlock)(TencentLBSHighFreqLocInfo *ocHighFreqLocInfo);
/**
 * 统计请求的流量等信息
 * @param  url 地址
 * @param  timeStamp 请求发生的时间
 * @param  uploadSize 上行数据大小
 * @param  downloadSize 下行数据大小
 * @param  consume 请求的耗时
 * @param  isOK 是否成功
 */
typedef void(^TencentLBSHttpStatusDataBlock)(NSString *url, int64_t timeStamp, int64_t uploadSize, int64_t downloadSize, int64_t consume, BOOL isOK);


typedef void(^TencentLBSLocationSceneBlock)(TencentLBSLocationScene *locationScene);

/**
 * debug下实时输出SDK内部的状态信息
 * @param status SDK内部的状态信息
 */
typedef void(^TencentLBSInnerStatusBlock)(NSString *status);

@protocol TencentLBSLocationAdaterDelegate;

@interface TencentLBSLocationAdapter : NSObject

/**
 *  实现了 TencentLBSLocationAdaterDelegate 协议的类指针。
 */
@property (nonatomic, weak) id<TencentLBSLocationAdaterDelegate> delegate;


+(void) setTencentLBSHttpStatusDataBlock:(TencentLBSHttpStatusDataBlock) httpStatusDataBlock;

+(void)setTencentLBSInnerStatusCallback:(TencentLBSInnerStatusBlock) innerStatusBlock;

/**
 * @brief 初始化大定位SDK，在调用其它功能函数之前务必先调用此函数
 *
 * @param config 初始化配置
 * @see TencentLBSLocationConfig
 */
-(void *)initRouteMatch:(TencentLBSLocationConfig*)config;

/**
 *@brief 返回大定位的句柄，务必先调用-(void *)initRouteMatch:函数，再获取大定位句柄
 */
-(void *)fusionLocationEngineHandler;
/**
 * @brief 设置导航模式，巡航导航
 *
 * @param naviType
 * -1 无效状态
 * 0  巡航+导航
 * 1  导航+巡航
 * 2  纯导航,不开启巡航
 */
-(void)setNaviType:(int)naviType;
/**
 * @brief 设置道路模式
 *
 * @param routeMode
 * 0 驾车
 * 1 步行
 * 2 骑行
 * 3 公交
 * 4 货车
 */
-(void)setRouteMode:(int) routeMode;
///**
// * @brief 开启吸附开关，默认关闭
// *
// * @param level 用来控制控制台log是否输出，以及他们的级别,取值[0,6]
// * 0 不打印日志
// * 6 打印全部日志
// * @deprecated
// */
//+(void)setDebuggable:(int) level;
///**
//* @brief 开启吸附总开关，默认关闭
//* @param isOpen 是否开启日志
//* @param level 用来控制控制台log是否输出，以及他们的级别,取值[0,6]
//* 0 不打印日志
//* 6 打印全部日志
//*/
//+(void)setDebuggableWithOpen:(BOOL)isOpen withLevel:(TencentLBSLogLevel)level;

/**
 * @brief 设置当前显示比例尺下的数据格式类型
 * @param formatType
 * 0 sd格式
 * 1 4k格式
 */
-(void)setDisplayFormatType:(int)formatType;

/**
 * @brief 注册大定位场景识别的回调接口
 * @param locationSceneBlock 注册的回调接口，重制的时候可传入nil
 */
-(void)setLocationSenceWithBlock:(TencentLBSLocationSceneBlock _Nullable)locationSceneBlock;

/**
 * @brief 注册道路吸附结果监听，请在init后，startCommonLocation之前调用
 *
 * @param listener 注册的回调接口
 */
-(void)addMatchResultListener:(TencentLBSPosMatchResultBlock) listener;
/**
 * @brief 反注册道路吸附结果监听，请在destroy前调用
 *
 * @param listener 注册的回调接口
 */
-(void)removeMatchResultListener:(TencentLBSPosMatchResultBlock) listener;

/**
 * @brief 添加高频定位结果信息监听者
 * @param listener
*/
-(void)addHighFreqLocInfoListener:(TencentLBSHighFreqLocBlock) listener;

/**
 * @brief 删除高频定位结果信息监听者
 * @param listener
*/
-(void)removeHighFreqLocInfoListener:(TencentLBSHighFreqLocBlock) listener;

/**
 * @brief 销毁大定位SDK，与init成对出现
 */
-(void)destroyRouteMatch;
///**
// * @brief      信号记录功能开关
// * @details    上层通过此接口控制是否打开定位引擎的信号日志。定位引擎信号日志文件以时间命名，后缀名为loc。
// *             如20170223171307.loc表示2017年2月23日 17点13分07秒开始记录的日志文件。
// * @param      open
// *             - false：关闭
// *             - true：打开
// * @param      encryption
// *             - false：不加密
// *             - true：加密
// * @param      log_level
// *             - 0：简单定位信息
// *             - 1：全部信息输出
// * @note       默认情况下，不开启loc文件记录
// * @note       连续两次设置open等于true会导致引擎内部关闭正在写的文件，重新再开一个文件写日志
// * @note       log生成目录为工作目录（工作目录通过：ResourceConfig.log_path设置）
// * @note       异步接口
// * @note       打开日志请设置 open=YES,encryption=NO,log_level=1
// * @deprecated
// */
//-(void)setSwitchDebugIsOpen:(BOOL) open isEncrypt:(BOOL) encryption withLevel:(int)log_level;
/**
 * @brief 由外部传入模拟轨迹的点给大定位
 * @param mockPos 自定义的点
 */
-(void)setMockLocationToRouteMatch:(TencentLBSLocation*)mockPos;
/**
 * @brief 设置模拟轨迹模式，配合setMockLocationToRouteMatch使用,可在initRouteMatch之前调用
 * @param isMock 是否开启模拟轨迹模式
 * @note 当设置为YES时，接收setMockLocationToRouteMatch的点给大定位
 * @note 当设置为NO时，仅仅使用定位SDK内部的点给大定位
 */
-(void)setMockDebugMode:(BOOL)isMock;
/**
* 获取前序点,最多缓存70个点
*/
-(NSString *)lbsHistoryLocations;

/**
 * 开启手机朝向监听
 */
-(void)startUpdateHeading;

/**
 * 停止手机朝向监听
 */
-(void)stopUpdateHeading;


/**
 * 获取最新的定位点，外部最好判空
 */
- (TencentLBSLocation *)latestLocation;

/**
 * 由外部传入录音数据
 */
- (void)setAudioData:(NSData *)data;

/**
 * 设置deviceID
 */
- (void)setDeviceID:(NSString *)deviceID;


/**
 * 设置引导面数据，用于手机车道级导航
 *
 * @param guideArea {@link GuideArea}
 */
- (void)setGuideArea:(TencentLBSGuideArea*) guideArea;


/**
 * 删除引导面
 * @param routeId 路线id
 */
- (void)deleteGuideArea:(NSString*) routeId;

/**
 * @brief 开始日志回放
 *
 * @param fileName 		完整的文件名（包括绝对文件路径）
 * @param replayMode 	回放模式 (0 同步模式; 1 异步模式)
 * @param replaySpeed   回放倍速
 * @param isOnlySignal  是否仅回放信号
 */
- (void)startSimulator:(NSString *)filePath withMode:(int)replayMode withSpeed:(int)replaySpeed withIsOnlySignal:(BOOL)isOnlySignal;

/**
 * @brief 结束日志回放
 */
- (void)stopSimulator;

@end

#pragma mark - TencentLBSLocationAdaterDelegate

@protocol TencentLBSLocationAdaterDelegate <NSObject>

@optional

/**
 *  手机朝向改变时回调函数
 *  @param newHeading  新的定位朝向
 */
- (void)didUpdateHeading:(CLHeading *)newHeading;

/**
 *  是否展示定位朝向校准提示的回调函数
 */
- (BOOL)shouldDisplayHeadingCalibration;

@end

NS_ASSUME_NONNULL_END
