//
//  TNKWalkNavView.h
//  TencentNavKit
//
//  Created by mol on 2022/10/26.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <TencentNavKit/TencentNavKit.h>
#import <TencentNavKit/TNKWalkNavDelegate.h>
#import <TencentNavKit/TNKWalkNavViewDelegate.h>

NS_ASSUME_NONNULL_BEGIN


typedef enum _TNKWalkTTSMode
{
    TNKWalkTTSModeSilent  = TNKNavTTSModeSilent,   ///< 静音
    TNKWalkTTSModeSpeak   = TNKNavTTSModeDefault,  ///< 播报（你想选 Default 还是 Brief 都行）
} TNKWalkTTSMode;

/// 步行导航管理类
@interface TNKWalkNavView : TNKBaseNavView <TNKWalkNavDelegate>

/**
 *  @brief TNKRideNavView的回调,用于接收导航模式、日夜状态等变化.
 */
@property (nonatomic, weak, nullable) id<TNKWalkNavViewDelegate> delegate;

/**
 *  @brief 是否显示界面元素,默认NO。（不包含对导航面板的控制）
 */
@property (nonatomic, assign) BOOL showUIElements;

/**
 *  @brief 是否显示全览/退出全览切换按钮，默认NO
 */
@property (nonatomic, assign) BOOL showOverviewButton;

/**
 *  @brief 是否显示底部工具栏，默认NO（包含退出、剩余距离时间、预计到达时间、设置）
 */
@property (nonatomic, assign) BOOL showBottomToolbar;

/**
 *  @brief 是否显示提示(包括GPS变弱、恢复，手动刷新路线)，默认NO
 */
@property (nonatomic, assign) BOOL showToast;

/**
 *  @brief 是否显示路线刷新按钮，默认为NO. since 5.2.5
 */
@property (nonatomic, assign) BOOL showRouteRefreshButton;

@end

NS_ASSUME_NONNULL_END
