//
//  TNKDriveNavigationData.h
//  TencentNavKit
//
//  Created by mol on 2022/11/1.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class TNKSpeedMonitorStatus,
TNKElectronicEyeInfo,
TNKNavToWayPointInfo,
TNKHighwayFacilityInfo,
TNKNavRestrictionInfo;

/**
 *  @brief 导航面板数据类.包含路名，距离，时间等数据.
 */
@interface TNKTravelNavigationData : NSObject

/**
 * @brief 下一段路名
 */
@property (nonatomic, readonly, nullable) NSString *nextRoadName;

/**
 * @brief 当前路名
 */
@property (nonatomic, readonly) NSString *currentRoadName;

/**
 * @brief 高速出口名称
 */
@property (nonatomic, readonly, nullable) NSString *exitName;

/**
 * @brief 高速入口名称
 * @since 5.4.3
 */
@property (nonatomic, readonly, nullable) NSString *entranceName;


/**
 * @brief 到下一个转向点的距离 单位:米
 */
@property (nonatomic, readonly) int nextDistanceLeft;

/**
 * @brief 剩余总距离 单位:米
 */
@property (nonatomic, readonly) int totalDistanceLeft;

/**
 * @brief 剩余总时间 单位:分钟
 */
@property (nonatomic, readonly) int totalTimeLeft;

/**
 * @brief 剩余途径点信息
 */
@property (nonatomic, readonly) NSArray<TNKNavToWayPointInfo *> *waypoints;

/**
 * @brief 限速值，单位: 公里／小时
 */
@property (nonatomic, readonly) int limitSpeed;

/**
 * @brief UI是否需要做超速警告. since. 5.3.5
 */
@property (nonatomic, readonly) BOOL isOverSpeed;

/**
 * @brief 当前速度值，单位: 公里／小时 数值为负时当前速度值无效
 */
@property (nonatomic, readonly) int currentSpeed;

/**
 * @brief 当前路口转向箭头图片
 */
@property (nonatomic, readonly) UIImage *intersectionImage;

/**
 * @brief 当前路口转向类型. since 5.4.1
 */
@property (nonatomic, readonly) int intersectionType;

/**
 * @brief 下一个路口箭头图片，当两个转弯动作很近时值不为空
 */
@property (nonatomic, readonly, nullable) UIImage *nextIntersectionImage;

/**
 * @brief 下下一个道路名，当两个转弯动作很近时值不为空
 */
@property (nonatomic, readonly, nullable) NSString *nextNextRoadName;

/**
 * @brief 区间测速更新状态 since 5.2.5
 */
@property (nonatomic, readonly, nullable) TNKSpeedMonitorStatus *speedMonitorStatus;

/**
 * @brief 摄像头信息
 */
@property (nonatomic, readonly, nullable) TNKElectronicEyeInfo *electronicEyeInfo;

/**
 * @brief 实时剩余红绿灯个数
 * @since 5.2.8
 */
@property (nonatomic, readonly) int remainTrafficLightCount;

/**
 * @brief 前方高速休息区/收费站信息。为nil时表示没有
 * @since 6.0.0
 */
@property (nonatomic, readonly, nullable) TNKHighwayFacilityInfo *highwayFacilityInfo;

/**
 * @brief 当前是否有Tips放大图。
 * @since 5.3.7
 */
@property (nonatomic, readonly) BOOL isShowingTipsMap;

/**
 * @brief Tips放大图信息， 用于放大图顶部进度条的绘制。
 * @since 5.3.7
 */
@property (nonatomic, readonly, nullable) NSString *tipsText;

/**
 * @brief Tips放大图剩余距离，单位：米， 用于放大图顶部进度条的绘制。
 * @since 5.3.7
 */
@property (nonatomic, readonly) int tipsRemainingDistance;

/**
 * @brief 本次导航已行驶时间，单位：秒
 */
@property (nonatomic, readonly) int passedTime;

/**
 * @brief 超速类型，0：无数据 1：不超速  2：超速提醒  3：严重超速
 */
@property (nonatomic, readonly) int overSpeedType;

/**
 * @brief 本次导航已行驶里程，单位：米
 */
@property (nonatomic, readonly) int passedDistance;

/**
 * @brief 前方违反交规的信息
 */
@property (nonatomic, readonly) TNKNavRestrictionInfo *navRestrictionInfo;

@end

NS_ASSUME_NONNULL_END

