//
//  TNKLocationSimulator.h
//  TencentNavKit
//
//  Created by mol on 2023/2/27.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, TNKSimulateLocationsType) {
    TNKSimulateLocationsTypeAlongCurrentRoute   = 0,    ///< 根据当前路线模拟定位
    TNKSimulateLocationsTypeAlongInitialRoute   = 1,    ///< 根据初始规划的路线模拟定位，中途更改路线不影响模拟的定位
    TNKSimulateLocationsTypeReplay              = 2,    ///< 轨迹回放
};  ///< 模拟定位模式

/**
 *  @brief 定位模拟器，用于调试。
 */
@protocol TNKLocationSimulator <NSObject>

/**
 *  @brief 是否启用模拟导航功能，默认为NO。需要在导航开启前设置
 */
@property (nonatomic, assign) BOOL enabled;

/**
 *  @brief 模拟定位模式
 */
@property (nonatomic, assign) TNKSimulateLocationsType simulateLocationsType;

/**
 *  @brief 模拟导航车速，单位km/h，根据路线模拟定位模式时生效，导航过程设置中依然生效
 *  驾车导航：设置范围[5,120]，默认55;
 *  步骑行导航：设置范围[2，120]，默认5;
 */
@property (nonatomic, assign) int simulationSpeed;

/**
 *  @brief 轨迹回放的gps文件路径。轨迹回放模式时生效
 */
@property (nonatomic, copy, nullable) NSString *filePath;

@end

NS_ASSUME_NONNULL_END
