//
//  TNKLocationAdapter.h
//  TencentNavKit
//
//  Created by mol on 2021/6/10.
//  Copyright © 2021 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentLBS/TencentLBS.h>
#import <TencentNavKit/TNKLocationListenerConfig.h>

NS_ASSUME_NONNULL_BEGIN

/// 定位管理类
@interface TNKLocationAdapter : NSObject

/// 单例
+ (instancetype)sharedInstance;

- (void)setDebugLog:(BOOL)on;

/// 设置是否开启定位作弊检测功能，默认为false,开启定位之前调用
@property (nonatomic, assign) BOOL enableAntiMock;

/**
 * 设置离线定位数据库大小阈值
 * @param size  单位MB，默认50MB
 */
//- (void)setOfflineDBSize:(NSUInteger)size;

/// 添加定位监听
- (void)addLocationListener:(id<TencentLBSLocationManagerDelegate>)delegate;

/// 移除定位监听
- (void)removeLocationListener:(id<TencentLBSLocationManagerDelegate>)delegate;

/// 添加定位监听
- (void)addLocationListener:(id<TencentLBSLocationManagerDelegate>)delegate 
              lisenerConfig:(TNKLocationListenerConfig * _Nullable)lisenerConfig;

@end

NS_ASSUME_NONNULL_END
