//
//  TNKHighwayFacilityInfo.h
//  TencentNavKit
//
//  Created by mol on 2020/3/31.
//  Copyright © 2020 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef enum _TNKHighwayFacilityType
{
    TNKHighwayFacilityTypeSeatingArea = 1, /**< 服务区 */
    TNKHighwayFacilityTypeTollStation = 2, /**< 收费站 */
} TNKHighwayFacilityType;

/// 高速休息区、收费站信息单条信息
@interface TNKHighwayFacilityItem : NSObject
// 类型
@property (nonatomic, readonly) TNKHighwayFacilityType type;
// 名字
@property (nonatomic, readonly) NSString *name;
// 距离
@property (nonatomic, readonly) int remainingDistance;

@end

/// 高速休息区、收费站信息
@interface TNKHighwayFacilityInfo : NSObject

@property (nonatomic, readonly) NSArray<TNKHighwayFacilityItem *> *facilityItems;

@end

NS_ASSUME_NONNULL_END
