//
//  TNKDriveRoutePlanService.h
//  TencentNavKit
//
//  Created by mol on 2023/8/28.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKDriveCommonObj.h>
#import <TencentNavKit/TNKSearchTask.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 独立算路服务，算路结果不能用于导航
 */
@interface TNKDriveRoutePlanService : NSObject

/// 单例模式，获取独立算路管理对象
+ (instancetype)sharedInstance;

- (instancetype)init NS_UNAVAILABLE;

/**
 * @brief 发起驾车导航路线规划，不能应用于开启导航. 通过路线规划请求配置起点、终点、途经点(可选)、规划参数(可选)发起路线规划.
 * @param request 路线规划请求
 * @param completion 路线规划完成回调
 *
 * @return 路线规划任务
 *
 * 错误信息参考TNKDriveRouteSearchErrorCode, TNKDriveRouteSearchErrorDomain
 */
- (TNKSearchTask * _Nullable)searchRoutesWithRequest:(TNKDriveRouteRequest *)request
                                          completion:(void (^)(TNKDriveRouteSearchResult * _Nullable searchResult,
                                                               NSError * _Nullable error))completion;
@end

NS_ASSUME_NONNULL_END
