//
//  TNKCustomAreaView.h
//  TencentNavKit
//
//  Created by xzg on 2025/7/25.
//  Copyright © 2025 Tencent. All rights reserved.
//


#import <UIKit/UIKit.h>

@class TNKCustomAreaView;

/**
 * 自定义区域视图的代理协议
 */
@protocol TNKCustomAreaViewDelegate <NSObject>
@optional
/**
 * 自定义区域高度已经改变
 */
- (void)customAreaView:(TNKCustomAreaView *)customAreaView didChangeHeight:(CGFloat)height;
@end

@interface TNKCustomAreaView : UIView

/**
 * 代理
 */
@property (nonatomic, weak) id<TNKCustomAreaViewDelegate> delegate;

/**
 * 内容容器视图（用户应该将自定义内容添加到此视图）
 */
@property (nonatomic, strong, readonly) UIView *contentView;

/**
 * 当前高度
 */
@property (nonatomic, assign, readonly) CGFloat currentHeight;

/**
 * 设置高度
 * @param height 目标高度
 */
- (void)setHeight:(CGFloat)height;

@end
