//
//  TNKBaseNavViewDelegate.h
//  TencentNavKit
//
//  Created by mol on 2022/12/28.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <TencentNavKit/TNKNavViewCommonObj.h>

NS_ASSUME_NONNULL_BEGIN

@class TNKBaseNavView;


/// 导航地图回调
@protocol TNKBaseNavViewDelegate <NSObject>

@optional

/**
 * @brief 获取导航模式改变回调.
 * @param navView 驾车地图
 * @param mode 导航模式
 * @param followed 是否跟随
 */
- (void)navView:(TNKBaseNavView *)navView didChangeUIMode:(TNKNavUIMode)mode followed:(BOOL)followed;

/**
 * @brief 获取日夜状态改变回调.
 * @param navView 驾车地图
 * @param status 日夜状态
 */
- (void)navView:(TNKBaseNavView *)navView didChangeDayNightStatus:(TNKNavDayNightStatus)status;

/**
 * @brief 点击退出按钮的回调.
 * @param navView 驾车地图
 */
- (void)navViewCloseButtonClicked:(TNKBaseNavView *)navView;

@end

NS_ASSUME_NONNULL_END
