//
//  TencentLBSStaticConfig.h
//  TencentLBS
//
//  Created by Ranyruan on 2023/6/14.
//  Copyright © 2023 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@protocol TencentLBSDeviceInfoDelegate <NSObject>

@required

/**
 * 获取idfa
 */
- (NSString *)getIdentifierForIdentifier;

/**
 * 获取idfv
 */
- (NSString *)getIdentifierForVendor;

/**
 * 获取原始的机型
 */
- (NSString *)getDeviceModel;

@end

@interface TencentLBSStaticConfig : NSObject
/**
 *  实现了 TencentLBSDeviceInfoDelegate 协议的类指针。
 */
@property (nonatomic, weak) id<TencentLBSDeviceInfoDelegate> delegate;

- (instancetype) __unavailable init;

+ (instancetype)sharedInstance;

@end

NS_ASSUME_NONNULL_END
