//
//  QPolygonView.h
//  QMapKit
//
//  Created by fan on 2017/5/21.
//  Copyright © 2017年 tencent. All rights reserved.
//

#import "QPolygon.h"
#import "QOverlayPathView.h"

/**
 *  @brief  此类是QPolygon的显示多边形View
 *
 * 可以通过QOverlayPathView修改其fill和stroke属性来配置样式
 */
@interface QPolygonView : QOverlayPathView

/**
 *  @brief  关联的QPolygon对象
 */
@property (nonatomic, readonly) QPolygon    *polygon;

/**
 *  @brief polygon虚线描边样式, 默认为 QOverlayStrokeType_Default
 */
@property (nonatomic, assign) QOverlayStrokeType lineType;

/**
 *  @brief 虚线描边间距比例
 *	样式为QOverlayStrokeType_Dash时, lineDashPattern为实线和虚线的线长序列（元素个数必须是偶数）
 */
@property (nonatomic, copy) NSArray<NSNumber *> *lineDashPattern;

/**
 * @brief 纹理间距
 */
@property (nonatomic, assign) CGFloat textureGap;

/**
 *	@brief 虚线描边纹理图片, 与QOverlayStrokeType_Dot搭配使用
 *	图片为nil时，使用圆点样式
 */
@property (nonatomic, strong) UIImage *styleTextureImage;

/**
 * @brief 是否响应点击. 默认YES
 */
@property(nonatomic,getter=isUserInteractionEnabled) BOOL userInteractionEnabled;

/**
 *  @brief  根据指定的多边形生成一个多边形view
 *
 *  @param polygon 指定的多边形数据对象
 *
 *  @return 新生成的多边形view
 */
- (instancetype)initWithPolygon:(QPolygon *)polygon;


@end
