#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

#ifndef __has_feature      // 可选项
#define __has_feature(x) 0 // 与非 clang 编译器兼容
#endif

#ifndef NS_RETURNS_NOT_RETAINED
#if __has_feature(attribute_ns_returns_not_retained)
#define NS_RETURNS_NOT_RETAINED __attribute__((ns_returns_not_retained))
#else
#define NS_RETURNS_NOT_RETAINED
#endif
#endif

@class QMapDatabase;
@class QMapStatement;

typedef NS_ENUM(int, SqliteValueType) {
    SqliteValueTypeInteger = 1,
    SqliteValueTypeFloat   = 2,
    SqliteValueTypeText    = 3,
    SqliteValueTypeBlob    = 4,
    SqliteValueTypeNull    = 5
};

@interface QMapResultSet : NSObject

@property (nonatomic, retain, nullable) QMapDatabase *parentDB;
@property (atomic, retain, nullable) NSString *query;
@property (readonly) NSMutableDictionary *columnNameToIndexMap;
@property (atomic, retain, nullable) QMapStatement *statement;

- (void)close;
- (BOOL)next;
- (BOOL)nextWithError:(NSError * _Nullable __autoreleasing *)outErr;
- (BOOL)step;
- (BOOL)stepWithError:(NSError * _Nullable __autoreleasing *)outErr;
- (BOOL)hasAnotherRow;

@property (nonatomic, readonly) int columnCount;
- (int)columnIndexForName:(NSString*)columnName;
- (NSString * _Nullable)columnNameForIndex:(int)columnIdx;
- (int)intForColumn:(NSString*)columnName;
- (int)intForColumnIndex:(int)columnIdx;
- (long)longForColumn:(NSString*)columnName;
- (long)longForColumnIndex:(int)columnIdx;
- (long long int)longLongIntForColumn:(NSString*)columnName;
- (long long int)longLongIntForColumnIndex:(int)columnIdx;
- (unsigned long long int)unsignedLongLongIntForColumn:(NSString*)columnName;
- (unsigned long long int)unsignedLongLongIntForColumnIndex:(int)columnIdx;
- (BOOL)boolForColumn:(NSString*)columnName;
- (BOOL)boolForColumnIndex:(int)columnIdx;
- (double)doubleForColumn:(NSString*)columnName;
- (double)doubleForColumnIndex:(int)columnIdx;


- (NSString * _Nullable)stringForColumn:(NSString*)columnName;
- (NSString * _Nullable)stringForColumnIndex:(int)columnIdx;
- (NSDate * _Nullable)dateForColumn:(NSString*)columnName;
- (NSDate * _Nullable)dateForColumnIndex:(int)columnIdx;
- (NSData * _Nullable)dataForColumn:(NSString*)columnName;
- (NSData * _Nullable)dataForColumnIndex:(int)columnIdx;
- (const unsigned char * _Nullable)UTF8StringForColumn:(NSString*)columnName;
- (const unsigned char * _Nullable)UTF8StringForColumnName:(NSString*)columnName __deprecated_msg("Use UTF8StringForColumn instead");
- (const unsigned char * _Nullable)UTF8StringForColumnIndex:(int)columnIdx;
- (id _Nullable)objectForColumn:(NSString*)columnName;
- (id _Nullable)objectForColumnName:(NSString*)columnName __deprecated_msg("Use objectForColumn instead");
- (SqliteValueType)typeForColumn:(NSString*)columnName;
- (SqliteValueType)typeForColumnIndex:(int)columnIdx;
- (id _Nullable)objectForKeyedSubscript:(NSString *)columnName;
- (id _Nullable)objectAtIndexedSubscript:(int)columnIdx;
- (NSData * _Nullable)dataNoCopyForColumn:(NSString *)columnName NS_RETURNS_NOT_RETAINED;
- (NSData * _Nullable)dataNoCopyForColumnIndex:(int)columnIdx NS_RETURNS_NOT_RETAINED;
- (BOOL)columnIndexIsNull:(int)columnIdx;
- (BOOL)columnIsNull:(NSString*)columnName;
@property (nonatomic, readonly, nullable) NSDictionary *resultDictionary;
- (NSDictionary * _Nullable)resultDict __deprecated_msg("Use resultDictionary instead");
- (void)kvcMagic:(id)object;
- (BOOL)bindWithArray:(NSArray*)array;
- (BOOL)bindWithDictionary:(NSDictionary *)dictionary;
@end

NS_ASSUME_NONNULL_END
