//
//  QMapEventDataReporter.h
//  QMapFoundationKit
//
//  Created by halldwang on 2025/1/7.
//  Copyright © 2025 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "QBaseReportEvent.h"


NS_ASSUME_NONNULL_BEGIN

static dispatch_queue_t qmap_event_data_report_queue(void)
{
    static dispatch_queue_t data_report_queue;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        data_report_queue = dispatch_queue_create("com.qmapsdk.lbs.data.report", DISPATCH_QUEUE_SERIAL);
    });
    return data_report_queue;
}

@interface QMapEventDataReporter : NSObject

/// 添加公用上报字段,  所有上报均带有设置的字段
- (void)setCommonReportParams:(NSDictionary*)params;

/// 上报单例
+ (QMapEventDataReporter*)reporter;

/// 上报内容
- (void)reportEvent:(QMapEventDataReport*)event;

@end

NS_ASSUME_NONNULL_END
