//
//  QMapDatabaseQueue.h
//  fmdb
//

#import <Foundation/Foundation.h>
#import "QMapDatabase.h"

NS_ASSUME_NONNULL_BEGIN

@interface QMapDatabaseQueue : NSObject

@property (atomic, retain, nullable) NSString *path;
@property (atomic, readonly) int openFlags;
@property (atomic, copy, nullable) NSString *vfsName;

+ (nullable instancetype)databaseQueueWithPath:(NSString * _Nullable)aPath;
+ (nullable instancetype)databaseQueueWithURL:(NSURL * _Nullable)url;
+ (nullable instancetype)databaseQueueWithPath:(NSString * _Nullable)aPath flags:(int)openFlags;
+ (nullable instancetype)databaseQueueWithURL:(NSURL * _Nullable)url flags:(int)openFlags;

- (nullable instancetype)initWithPath:(NSString * _Nullable)aPath;
- (nullable instancetype)initWithURL:(NSURL * _Nullable)url;
- (nullable instancetype)initWithPath:(NSString * _Nullable)aPath flags:(int)openFlags;
- (nullable instancetype)initWithURL:(NSURL * _Nullable)url flags:(int)openFlags;
- (nullable instancetype)initWithPath:(NSString * _Nullable)aPath flags:(int)openFlags vfs:(NSString * _Nullable)vfsName;
- (nullable instancetype)initWithURL:(NSURL * _Nullable)url flags:(int)openFlags vfs:(NSString * _Nullable)vfsName;

+ (Class)databaseClass;

- (void)close;
- (void)interrupt;
- (void)inDatabase:(__attribute__((noescape)) void (^)(QMapDatabase *db))block;
- (void)inTransaction:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;
- (void)inDeferredTransaction:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;
- (void)inExclusiveTransaction:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;
- (void)inImmediateTransaction:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;
- (NSError * _Nullable)inSavePoint:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;
- (BOOL)checkpoint:(QMapDBCheckpointMode)checkpointMode error:(NSError * _Nullable *)error;
- (BOOL)checkpoint:(QMapDBCheckpointMode)checkpointMode name:(NSString * _Nullable)name error:(NSError * _Nullable *)error;
- (BOOL)checkpoint:(QMapDBCheckpointMode)checkpointMode name:(NSString * _Nullable)name logFrameCount:(int * _Nullable)logFrameCount checkpointCount:(int * _Nullable)checkpointCount error:(NSError * _Nullable *)error;

@end

NS_ASSUME_NONNULL_END
