//
//  QMapDatabasePool.h
//  fmdb
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class QMapDatabase;


@interface QMapDatabasePool : NSObject

@property (atomic, copy, nullable) NSString *path;
@property (atomic, unsafe_unretained, nullable) id delegate;
@property (atomic, assign) NSUInteger maximumNumberOfDatabasesToCreate;
@property (atomic, readonly) int openFlags;
@property (atomic, copy, nullable) NSString *vfsName;

+ (instancetype)databasePoolWithPath:(NSString * _Nullable)aPath;
+ (instancetype)databasePoolWithURL:(NSURL * _Nullable)url;
+ (instancetype)databasePoolWithPath:(NSString * _Nullable)aPath flags:(int)openFlags;
+ (instancetype)databasePoolWithURL:(NSURL * _Nullable)url flags:(int)openFlags;
- (instancetype)initWithPath:(NSString * _Nullable)aPath;
- (instancetype)initWithURL:(NSURL * _Nullable)url;
- (instancetype)initWithPath:(NSString * _Nullable)aPath flags:(int)openFlags;
- (instancetype)initWithURL:(NSURL * _Nullable)url flags:(int)openFlags;
- (instancetype)initWithPath:(NSString * _Nullable)aPath flags:(int)openFlags vfs:(NSString * _Nullable)vfsName;
- (instancetype)initWithURL:(NSURL * _Nullable)url flags:(int)openFlags vfs:(NSString * _Nullable)vfsName;

+ (Class)databaseClass;

@property (nonatomic, readonly) NSUInteger countOfCheckedInDatabases;
@property (nonatomic, readonly) NSUInteger countOfCheckedOutDatabases;
@property (nonatomic, readonly) NSUInteger countOfOpenDatabases;

- (void)releaseAllDatabases;
- (void)inDatabase:(__attribute__((noescape)) void (^)(QMapDatabase *db))block;
- (void)inTransaction:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;
- (void)inExclusiveTransaction:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;
- (void)inDeferredTransaction:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;
- (void)inImmediateTransaction:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;
- (NSError * _Nullable)inSavePoint:(__attribute__((noescape)) void (^)(QMapDatabase *db, BOOL *rollback))block;

@end

@interface NSObject (QMapDatabasePoolDelegate)

- (BOOL)databasePool:(QMapDatabasePool*)pool shouldAddDatabaseToPool:(QMapDatabase*)database;
- (void)databasePool:(QMapDatabasePool*)pool didAddDatabase:(QMapDatabase*)database;

@end

NS_ASSUME_NONNULL_END
