//
//  QMapDatabaseAdditions.h
//  fmdb
//

#import <Foundation/Foundation.h>
#import "QMapDatabase.h"

NS_ASSUME_NONNULL_BEGIN

@interface QMapDatabase (QMapDatabaseAdditions)

- (int)intForQuery:(NSString*)query, ...;
- (long)longForQuery:(NSString*)query, ...;
- (BOOL)boolForQuery:(NSString*)query, ...;
- (double)doubleForQuery:(NSString*)query, ...;
- (NSString * _Nullable)stringForQuery:(NSString*)query, ...;
- (NSData * _Nullable)dataForQuery:(NSString*)query, ...;
- (NSDate * _Nullable)dateForQuery:(NSString*)query, ...;
- (BOOL)tableExists:(NSString*)tableName;
- (QMapResultSet * _Nullable)getSchema;
- (QMapResultSet * _Nullable)getTableSchema:(NSString*)tableName;
- (BOOL)columnExists:(NSString*)columnName inTableWithName:(NSString*)tableName;
- (BOOL)columnExists:(NSString*)tableName columnName:(NSString*)columnName __deprecated_msg("Use columnExists:inTableWithName: instead");
- (BOOL)validateSQL:(NSString*)sql error:(NSError * _Nullable __autoreleasing *)error;

@property (nonatomic) uint32_t applicationID;

#if TARGET_OS_MAC && !TARGET_OS_IPHONE

@property (nonatomic, retain) NSString *applicationIDString;

#endif

@property (nonatomic) uint32_t userVersion;

@end

NS_ASSUME_NONNULL_END
