//
//  QEventDataCacheManager.h
//  QMapFoundationKit
//
//  Created by KeithCao on 2025/3/3.
//  Copyright © 2025 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "QMapDB.h"

NS_ASSUME_NONNULL_BEGIN

@class QMapEventDataReport;

@interface QEventDataCacheManager : NSObject

- (instancetype)initWithDatabasePath:(NSString *)path clsConfig:(NSDictionary *)config;

@property (nonatomic, strong) NSMutableDictionary <NSString *, QMapEventDataReport *> *reportCircleMemoryCache;

- (void)updateCLSConfig:(NSDictionary *)config;

- (int)circleMemoryCacheCount;

- (void)addEventToReportCircleMemoryCache:(QMapEventDataReport *)event;

- (void)addImmediateEventToDataBase:(QMapEventDataReport *)event;

- (void)readUnreportedDBData;

- (void)clearCircleCacheAfterReported:(NSArray <NSDictionary *> *)events;

- (void)clearCacheAtDatabase:(NSArray <NSDictionary *> *)events;

@end

NS_ASSUME_NONNULL_END
