//
//  QBaseReportEvent.h
//  QMapFoundationKit
//
//  Created by KeithCao on 2022/4/18.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// crash上报枚举

/**
 crashType
 */
typedef enum CrashTypeSetKey {
    CrashTypeIOSMode  = 0, // @"ns_exception"
    CrashTypeNativeMode   = 1 // @"native"
} CrashTypeSetKey;

typedef enum SourceTypeSetKey {
    SourceTypeReportedMode  = 0, // @"reported",
    SourceTypeBuglyMode = 1, // @"bugly"
    SourceTypeBuglyQQMode = 2, // @"buglyqq"
    
} SourceTypeSetKey;

typedef enum CrashCategorySetKey {
    CrashCategoryCrashMode  = 0, // @"caught_exception"
    CrashCategoryAaughtExceptionMode  = 1, //  @"crash";
    CrashCategoryANRMode  = 2, // @"anr"
} CrashCategorySetKey;


@interface QBaseReportEvent : NSObject

/// 事件代码
@property (nonatomic, copy) NSString* eventCode;

/// 事件上报参数
@property (nonatomic, strong) NSDictionary* params;

@end

@interface QBaseReportCofig : NSObject

/// 灯塔初始化开关，true代表关开启塔初始化功能
@property (nonatomic) BOOL beaconEnable;

/// 灯塔日志开关 true代表允许上报
@property (nonatomic) BOOL beaconLogEnable;

@end

/**
 * crash上报类
 */
@interface QReportCrashInfo : NSObject

/// crash来源
@property (nonatomic, assign) SourceTypeSetKey source;

/// 应用包名
@property (nonatomic, copy) NSString* package_name;

/// 进程信息
@property (nonatomic, copy) NSString* process;

/// 线程信息
@property (nonatomic, copy) NSString* thread;

/// 崩溃信息摘要
@property (nonatomic, copy) NSString* message;

/// 崩溃地址
@property (nonatomic, copy) NSString* crash_address;

/// crash堆栈 异常信息
@property (nonatomic, copy) NSException* stack_trace;

/// 额外信息
@property (nonatomic, copy) NSString* extra_message;

/// crash分类
@property (nonatomic, assign) CrashCategorySetKey crash_category;

/// crash类型
@property (nonatomic, assign) CrashTypeSetKey crash_type;

/// crash异常信息 SIGSEGV |……
@property (nonatomic, copy) NSString* crash_sub_type;

/// 模块 nav | map | loc | ls | track | base | tts | tencent | other | ……
@property (nonatomic, copy) NSString* module_name;

/// 场景，多个以 "_" 分隔，in_navigation | ….
@property (nonatomic, copy) NSString* scene;

/// 时长：使用时长，毫秒
@property (nonatomic, assign) long duration;

/// crash时间：毫秒
@property (nonatomic, assign) long crash_time;

/// CrashID
@property (nonatomic, copy)  NSString* crash_uuid;

/// 用户/设备ID
@property (nonatomic, copy)  NSString* user_id;

/// 设备ID
@property (nonatomic, copy)  NSString* device_id;

/// 地图key
@property (nonatomic, copy)  NSString* map_key;

/// 导航key
@property (nonatomic, copy)  NSString* nav_key;

/// 地图版本号
@property (nonatomic, copy)  NSString* map_version;

/// 导航版本号
@property (nonatomic, copy)  NSString* nav_version;

/// 扩展信息
@property (nonatomic, copy)  NSString* ext;

/// 会话ID
@property (nonatomic, copy)  NSString* session_uuid;

/// 操作系统版本
@property (nonatomic, copy)  NSString* os_version;

@end


/**
 * 用量事件上报类
 */
@interface QReportCrashUserScene : NSObject

/// 场景，例如 global_init | set_device_id ｜init_nav | init_map | …
@property (nonatomic, copy)  NSString* scene_name;

/// session id：一次app生命周期唯一
@property (nonatomic, copy)  NSString* session_uuid;

/// 导航用户ID
@property (nonatomic, copy)  NSString* user_id;

/// 设备ID
@property (nonatomic, copy)  NSString* device_id;

/// 地图key
@property (nonatomic, copy)  NSString* map_key;

/// 导航key
@property (nonatomic, copy)  NSString* nav_key;

/// 地图版本号
@property (nonatomic, copy)  NSString* map_version;

/// 导航版本号
@property (nonatomic, copy)  NSString* nav_version;

@end


/// 统计的基本数据类型,只统计NSString和数值类型, 子类继承时, 定义property需注意
@interface QNetflowItem : NSObject

/// 服务对应的标识码。
@property (nonatomic, copy) NSString* biz_type;

/// url链接，可空
@property (nonatomic, copy) NSString* url;

/// 网络请求耗时，耗时
@property (nonatomic, assign) int64_t rt;

/// 上行流量，单位: kb
@property (nonatomic, assign) double up;

/// 下行流量，单位: kb
@property (nonatomic, assign) double dw;

/// 网络请求发出上行时的时间. 单位毫秒
@property (nonatomic, assign) int64_t up_time;

/// 网络请求收到下行时间. 单位毫秒
@property (nonatomic, assign) int64_t dw_time;

/// 网络请求类型
@property (nonatomic, copy) NSString* method;

/// 失败错误码
@property (nonatomic, assign) int err;

/// http响应码
@property (nonatomic, assign) int httpCode;

@property (nonatomic, copy) NSString* raw_url;

@end


@interface QMapEventDataReport : NSObject

/// 事件名
@property (nonatomic, copy) NSString* name;
/// 是否立即上报
@property (nonatomic, assign) BOOL isImmediateReport;
/// 时间戳
@property (nonatomic, assign) int64_t time;
/// 类型 :  monitor \ perf \ biz
@property (nonatomic, copy) NSString* type;
/// 子类型
@property (nonatomic, copy) NSString* biz_type;

/// 网络类型
@property (nonatomic, readonly) NSString* netType;

/// 事件的唯一标识, 如果不赋值， 获取时会生成一个随机的id。
@property (nonatomic, copy) NSString* unique_id;
/// 公共参数
@property (nonatomic, strong) NSMutableDictionary* params;
/// 实际数据
@property (nonatomic, strong) NSDictionary* data;

/// 网络流量数据快捷设置入口
- (void)buildDataWithNetFlowItem:(QNetflowItem *)item;

@end

NS_ASSUME_NONNULL_END
