
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TNKUIComponentConfig : NSObject

/**
 * @brief 导航面板顶部空隙距离. 默认为全屏状态下避开状态栏. 取值范围为[0,100].
 */
@property (nonatomic, assign) NSUInteger panelTopGap;

/**
 *  @brief 是否展示顶部导航面板, 默认为YES
 */
@property (nonatomic, assign) BOOL navigationPanelEnabled;

/**
 *  @brief 设置在3D车头朝上和2D地图朝北模式下 显示/隐藏路口车道线. 默认为YES
 *         注意不管此参数如何设置，在全览模式和剩余全览模式下都会隐藏.
 */
@property (nonatomic, assign) BOOL guidedLaneEnabled;

/**
 *  @brief 是否显示底部工具栏，默认NO（包含退出、剩余距离时间、预计到达时间、设置）
 */
@property (nonatomic, assign) BOOL showBottomToolbar;

/**
 *  @brief 是否显示提示(包括GPS变弱、恢复，切换路线成功，手动刷新路线)，默认NO
 */
@property (nonatomic, assign) BOOL showToast;

/**
 *  @brief 是否显示当前车速， 默认NO
 */
@property (nonatomic, assign) BOOL showCurrentSpeedView;

/**
 *  @brief 是否展示严重超速视图，默认NO
 */
@property (nonatomic, assign) BOOL showGrossSpeedingView;

/**
 *  @brief 是否显示路况光柱图，默认NO，从7.0开始，光柱图默认是显示在下面的BottomToolbar上的（水平显示）
 */
@property (nonatomic, assign) BOOL showTrafficBar;

/**
 *  @brief 是否显示主辅路切换按钮，默认NO
 */
@property (nonatomic, assign) BOOL showRoadTypeButton;

/**
 *  @brief 是否显示限速、当前路名， 默认NO
 */
@property (nonatomic, assign) BOOL showLimitSpeedAndCurrentRoadNameView;

/**
 * @brief 是否显示智能定位. 默认NO. since 5.2.2
 */
@property (nonatomic, assign) BOOL showSmartLocView;

/**
 *  @brief 是否显示全览/退出全览切换按钮，默认NO
 */
@property (nonatomic, assign) BOOL showOverviewButton;

/**
 *  @brief 是否显示路线刷新按钮，默认为NO. since 5.2.5
 */
@property (nonatomic, assign) BOOL showRouteRefreshButton;

/**
 *  @brief 是否显示切换实时路况的按钮,默认NO
 */
@property (nonatomic, assign) BOOL showMapTrafficButton;

/**
 *  @brief 是否显示语音播报按钮,默认NO
 */
@property (nonatomic, assign) BOOL showBroadCastButton;

/**
 *  @brief 是否显示高速休息区信息，默认NO
 */
@property (nonatomic, assign) BOOL showServiceAreaInfo;

@end

NS_ASSUME_NONNULL_END
