//
//  TNKCarRouteColorPalette.h
//  TencentNavKit
//
//  Created by tabsong on 2022/1/4.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIColor.h>

NS_ASSUME_NONNULL_BEGIN

/// 导航路线颜色盘
@interface TNKRouteColorPalette : NSObject

/**
 * @brief 导航线在路况下的颜色配置
 * @param smoothColor 通畅颜色
 * @param slowColor 缓行颜色
 * @param verySlowColor 堵塞颜色
 * @param jamColor 严重堵塞颜色
 * @param eraseColor 已走过的路颜色. 目前不支持运行时更新.
 * @param unknownColor 未知路况颜色
 * @return 导航路线颜色盘
 */
- (instancetype)initWithSmoothColor:(UIColor * __nullable)smoothColor
                          slowColor:(UIColor * __nullable)slowColor
                      verySlowColor:(UIColor * __nullable)verySlowColor
                           jamColor:(UIColor * __nullable)jamColor
                         eraseColor:(UIColor * __nullable)eraseColor
                       unknownColor:(UIColor * __nullable)unknownColor;

/**
 *  @brief 通畅颜色
 */
@property(nullable, nonatomic, copy, readonly) UIColor *smoothColor;

/**
 *  @brief 缓行颜色
 */
@property(nullable, nonatomic, copy, readonly) UIColor *slowColor;

/**
 *  @brief 堵塞颜色
 */
@property(nullable, nonatomic, copy, readonly) UIColor *verySlowColor;

/**
 *  @brief 严重堵塞颜色
 */
@property(nullable, nonatomic, copy, readonly) UIColor *jamColor;

/**
 *  @brief 已走过的路颜色。
 *  @note 不支持动态更新.
 */
@property(nullable, nonatomic, copy, readonly) UIColor *eraseColor;

/**
 *  @brief 未知路况颜色
 */
@property(nullable, nonatomic, copy, readonly) UIColor *unknownColor;


@end

NS_ASSUME_NONNULL_END
