//
//  TNKRideCommonObj.h
//  TencentNavKit
//
//  Created by mol on 2022/12/27.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <TencentNavKit/TNKCommonObj.h>
#import <TencentNavKit/TNKSegmentItem.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 算路的路线数据类
 */
@interface TNKRideRoute : NSObject

/**
 * @brief 路线标签。比如：时间段、距离短等。
 */
@property (nonatomic, readonly) NSString *recommendReason;

/**
 * @brief 组成路线形状的坐标点数组
 */
@property (nonatomic, readonly) NSArray<TNKCoordinatePoint *> *routePoints;

/**
 * @brief 路线ID
 */
@property (nonatomic, readonly) NSString *routeID;

/**
 * @brief 总距离. 单位，米
 */
@property (nonatomic, readonly) int totalDistance;

/**
 * @brief 总预计时间. 单位，分钟
 */
@property (nonatomic, readonly) int totalTime;

/**
 * @brief 路线红绿灯个数
 */
@property (nonatomic, readonly) int trafficLightCount;

/**
 * @brief 导航起点
 */
@property (nonatomic, readonly) TNKSearchNavPoint *origin;

/**
 * @brief 导航终点
 */
@property (nonatomic, readonly) TNKSearchNavPoint *destination;

/**
 * @brief 路线规划时的路线状态数据.
 */
@property (nonatomic, readonly) NSArray <TNKSegmentItem *> *segmentItems;

/**
 * @brief 里程碑
 */
@property (nonatomic, readonly, nullable) NSArray<TNKRouteMilestone *> *milestones;

@end


/**
 * @brief 骑行算路返回数据类
 */
@interface TNKRideRouteSearchResult : NSObject

/**
 * @brief 路线数组，最多三个
 */
@property (nonatomic, readonly) NSArray<TNKRideRoute *> *routes;

@end

/**
 * @brief 导航过程中的路线实时数据
 */
@interface TNKRideNavRoute : NSObject

- (instancetype)init NS_UNAVAILABLE;

/// 构造方法
- (instancetype)initWithSearchRoute:(TNKRideRoute *)searchRoute;

/**
 * @brief 算路的路线数据类
 */
@property (nonatomic, readonly) TNKRideRoute *searchRoute;

/**
 * @brief 当前位置到终点剩余距离， 单位：米
 */
@property (nonatomic, readonly) int remainingDistance;

/**
 * @brief 当前位置到终点剩余时间，单位：分钟
 */
@property (nonatomic, readonly) int remainingTime;

@end

NS_ASSUME_NONNULL_END
