//
//  TNKRerouteCommon.h
//  TencentNavKit
//
//  Created by mol on 2022/12/7.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class TNKDriveRoute,
TNKRideRoute,
TNKWalkRoute;

/**
 * @brief 重新算路类型.
 */
typedef enum _TNKRerouteReason
{
    TNKRerouteReasonOffRoute                            = 1,    ///< 偏航重算
    TNKRerouteReasonChangingRoadType                    = 2,    ///< 平行路道路类型切换重算
    TNKRerouteReasonRefreshing                          = 3,    ///< 手动路线刷新重算
    TNKRerouteReasonChangingDestination                 = 4,    ///< 修改目的地重算
    TNKRerouteReasonChangingWayPoints                   = 5,    ///< 修改途径点重算
    TNKRerouteReasonChangingDestinationAndWayPoints     = 6,    ///< 修改目的地以及途径点重算
    TNKRerouteReasonChangingSearchOptions               = 7,    ///< 修改算路策略
    TNKRerouteReasonRestoringRoute                      = 8,    ///< 乘客选路重算
} TNKRerouteReason;

/**
 * @brief 驾车重新算路结果
 */
@interface TNKDriveRerouteResult : NSObject

/// 重算路的原因
@property (nonatomic, readonly) TNKRerouteReason rerouteReason;

/// 重算失败的错误信息，重算失败时不为空。
@property (nonatomic, readonly, nullable) NSError *error;

/// 重算新路线数据，重算成功时不为空。
@property (nonatomic, readonly, nullable) TNKDriveRoute *searchRoute;

@end

/**
 * @brief 骑行重新算路结果
 */
@interface TNKRideRerouteResult : NSObject

/// 重算路的原因
@property (nonatomic, readonly) TNKRerouteReason rerouteReason;

/// 重算失败的错误信息，重算失败时不为空。
@property (nonatomic, readonly, nullable) NSError *error;

/// 重算新路线数据，重算成功时不为空。
@property (nonatomic, readonly, nullable) TNKRideRoute *searchRoute;

@end

/**
 * @brief 步行重新算路结果
 */
@interface TNKWalkRerouteResult : NSObject

/// 重算路的原因
@property (nonatomic, readonly) TNKRerouteReason rerouteReason;

/// 重算失败的错误信息，重算失败时不为空。
@property (nonatomic, readonly, nullable) NSError *error;

/// 重算新路线数据，重算成功时不为空。
@property (nonatomic, readonly, nullable) TNKWalkRoute *searchRoute;

@end

NS_ASSUME_NONNULL_END
