//
//  TNKNavViewCommonObj.h
//  TencentNavKit
//
//  Created by mol on 2022/11/16.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 路口放大图宽高比
extern float const kTNKEnlargedIntersectionAspect;

/// 路口放大图进度条高度
extern float const kTNKEnlargedIntersectionProgressHeight;
/// 路口放大图进度条高度缩进20
extern float const kTNKEnlargedIntersectionProgressIndentation;


typedef enum _TNKNavUIMode
{
    TNKNavUIMode3DTowardsUp       = 0,      ///< 3D 车头朝上
    TNKNavUIMode2DMapTowardsNorth = 1,      ///< 2D 地图朝北
    TNKNavUIModeOverview          = 2,      ///< 全览模式
    TNKNavUIModeRemainingOverview = 3       ///< 剩余全览模式
} TNKNavUIMode;                             ///< 导航地图的导航模式

typedef enum _TNKNavDayNightMode
{
    TNKNavDayNightModeAuto        = 0,      ///< 自动切换
    TNKNavDayNightModeAlwaysDay   = 1,      ///< 始终白天
    TNKNavDayNightModeAlwaysNight = 2       ///< 始终黑夜
} TNKNavDayNightMode;                       ///< 导航地图的日夜间模式

typedef enum _TNKNavDayNightStatus
{
    TNKNavDayNightStatusDay       = 0,      ///< 白天
    TNKNavDayNightStatusNight     = 1,      ///< 黑夜
} TNKNavDayNightStatus;                     ///< 导航地图所处的日夜间状态


NS_ASSUME_NONNULL_END
